
/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Michael Brettlecker

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

package application;
	
import java.util.Calendar;
import java.util.Date;
import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.fxml.FXMLLoader;


public class Main extends Application {
	@Override
	public void start(Stage primaryStage) {
	
		try {
			BorderPane root;
			Date d1= new Date();
			Calendar cal = Calendar.getInstance();
			cal.setTime(d1);
			int month = cal.get(Calendar.MONTH);
			
			if(month==6 || month == 7) {
			root = (BorderPane)FXMLLoader.load(getClass().getResource("SampleS.fxml"));
			}
			else if (month == 9 || month == 10) {
			root = (BorderPane)FXMLLoader.load(getClass().getResource("SampleH.fxml"));
			}
			else if (month == 11 || month == 0) {
				root = (BorderPane)FXMLLoader.load(getClass().getResource("SampleW.fxml"));
				}
			else if (month == 3 || month == 4) {
				root = (BorderPane)FXMLLoader.load(getClass().getResource("SampleF2.fxml"));
				}
			else {
			root = (BorderPane)FXMLLoader.load(getClass().getResource("Sample.fxml"));
			}
			
			
			
			Scene scene = new Scene(root,570,600);
			
			scene.getStylesheets().add(getClass().getResource("application.css").toExternalForm());
			
			primaryStage.setTitle("Telekonsultation");
			primaryStage.setScene(scene);
			primaryStage.setResizable(false);
			primaryStage.show();
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public static void main(String[] args) {
		launch(args);

	}
}
