/*   License:

    ------------------------ Apache Version 2.0 license -------------------------
       Copyright (C) 2021 Michael Brettlecker

       Licensed under the Apache License, Version 2.0 (the "License");
       you may not use this file except in compliance with the License.
       You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

       Unless required by applicable law or agreed to in writing, software
       distributed under the License is distributed on an "AS IS" BASIS,
       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
       See the License for the specific language governing permissions and
       limitations under the License.
    -----------------------------------------------------------------------------
*/

package application;




import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;


import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.text.Text;


public class SampleController {
	
    @FXML
    private Button btn8;
    @FXML
    private TextField adrmail;

    @FXML
    private ImageView frhlng;
    @FXML
    private ImageView eggS;

    @FXML
    private TextField vorname;
    
    @FXML
    private MenuItem hndbch;

    @FXML
    private TextField nachname;

    @FXML
    private TextField soznr;
    @FXML
    private Text link01;
    @FXML
    private Text info01;
    
    @FXML
    private Button btn10;
    @FXML
    private Button btnMail;
    
   
    @FXML
    private Button btn9;

    @FXML
    void BtnKstart(ActionEvent event) {
    	String vrn = vorname.getText().replaceAll("\\s+", "");
		String nnm = nachname.getText().replaceAll("\\s+", "");
		String szn = soznr.getText().replaceAll("\\s+", "");
		if (vrn.isEmpty() || nnm.isEmpty() || szn.isEmpty()) {
			
			link01.setText("Bitte Namen & SV-Nr des Pat. angeben.");
			link01.setVisible(true);
		} else {
			try {
				Desktop.getDesktop().browse(new URL("https://meet.jit.si/"+vrn+nnm+szn).toURI());
			} catch (IOException | URISyntaxException e1) {
				
				e1.printStackTrace();
			}
		}
    }

    @FXML
    void btnLinkg(ActionEvent event) {
    	String vrn = vorname.getText().replaceAll("\\s+", "");
		String nnm = nachname.getText().replaceAll("\\s+", "");
		String szn = soznr.getText().replaceAll("\\s+", "");
		
		if (vrn.isEmpty() || nnm.isEmpty() || szn.isEmpty()) {
			link01.setText("Bitte Namen & SV-Nr des Pat. angeben.");
			link01.setVisible(true);
		} else {
		link01.setText("https://meet.jit.si/"+vrn+nnm+szn);
		link01.setVisible(true);
		info01.setVisible(true);
		
		}
		final Clipboard clipboard = Clipboard.getSystemClipboard();
	     final ClipboardContent content = new ClipboardContent();
	     content.putString("https://meet.jit.si/"+vrn+nnm+szn);
	    // content.putHtml("<b>Some</b> text");
	     clipboard.setContent(content);
	     
    }

    @FXML
    void btnNeu(ActionEvent event) {

			adrmail.setText("");
			vorname.setText("");
			nachname.setText("");
			soznr.setText("");
			link01.setText("");
			link01.setVisible(false);
			info01.setVisible(false);
			
			
			}
@FXML
void Hndbchstrt(ActionEvent event) {
	
	 try {
	      Desktop desktop = Desktop.getDesktop();
	      
	       desktop.open(new File("ressourcen\\handbuch_team.pdf"));
	    } catch (IOException ioe) {
	      ioe.printStackTrace();
	    }
	}


@FXML
void btnMailstrt(ActionEvent event) throws IOException, URISyntaxException {
	
	String mailadr = adrmail.getText();
	String nnm = nachname.getText();
	String vrn = vorname.getText().replaceAll("\\s+", "");
	String szn = soznr.getText().replaceAll("\\s+", "");
	
	
	Desktop desktop;
	if (Desktop.isDesktopSupported() 
	    && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
	  URI mailto = new URI("mailto:"+mailadr+"?subject=Telekonsultation%20Brettlecker&body=Sehr%20geehrte/r%20Herr/Frau,%20"+nnm+"%0A%0Ahier%20Ihr%20persnlicher%20Zugangslink%20zur%20Telekonsultation.%20https://meet.jit.si/"+vrn+nnm+szn+"%0A%0ABitte%20finden%20Sie%20im%20folgenden%20Link%20das%20Handbuch%20fr%20eine%20erfolgreiche%20Telekonsultation%20zum%20Download%20https://www.dropbox.com/s/12xtwssfd9lomd5/handbuch_patient.pdf?dl=0.%0A%0AMit%20freundlichen%20Gren%0A%0A%0AIhr%20Ordinationsteam%20Brettlecker");
	  desktop.mail(mailto);
	} else {
	  
	  throw new RuntimeException("desktop doesn't support mailto");
	}

}
}


