/*--------------------------------------------------------------------*/
/*                                                                    */
/*                         pcf8574                                    */
/*                     with i2cset                                    */
/*                                                                    */
/* This example shows how to switch eight outputs with two lines      */
/* using the PCF8574 I/O port expander.                               */
/*                                                                    */
/*--------------------------------------------------------------------*/

addr = "0x21"    -- get address with i2cdetect
clear = "00000000"b
address system "i2cset -y 1 " addr "0x"clear~c2x  -- set all output to 0

--create random Bits
bit1= random(0,1)
bit2= random(0,1)
bit3= random(0,1)
bit4= random(0,1)
bit5= random(0,1)
bit6= random(0,1)
bit7= random(0,1)
bit8= random(0,1)

byte = bit8|| bit7 || bit6 || bit5 || bit4 || bit3 || bit2 || bit1 -- create byte

address system "i2cset -y 1 " addr "0x"byte~b2x --displays the randomly generated byte

call syssleep 5

-- count binary from 0 to 255
val = 0
do i = 1 to 256
	address system "i2cset -y 1 " addr "0x"val~d2x
	val = val+1
	call syssleep 0.3
end
exit