::CLASS DatabaseHandler PUBLIC
-- Define the "conn" attribute for the DatabaseHandler class
::METHOD conn ATTRIBUTE
-- Define the "DB_URL" attribute for the DatabaseHandler class
::METHOD DB_URL ATTRIBUTE
-- Define the "DriverManager" attribute for the DatabaseHandler class
::METHOD DriverManager ATTRIBUTE
-- Define the "init" method for the DatabaseHandler class
::METHOD init
  EXPOSE DriverManager  -- Allow access to the DriverManager object
  -- Import the DriverManager object from the Java sql package using BSF
  DriverManager = bsf.import("java.sql.DriverManager")
/*Define the "initSettings" method for the DatabaseHandler class, which sets the DB_URL attribute*/
::METHOD initSettings PUBLIC
  EXPOSE  DB_URL  -- Allow access to the DB_URL attribute
  -- Set the DB_URL attribute to the path of the SQLite database
    DB_URL = "jdbc:sqlite:C:\Users\isada\IdeaProjects\JDK8\src\Application_ControlsFX_JDBC\DB.db"

/*Define the "connect" method for the DatabaseHandler class, which establishes a connection to the SQLite database*/
::METHOD connect PUBLIC
  EXPOSE DriverManager DB_URL conn -- Allow access to the DriverManager, DB_URL, and conn attributes
  SIGNAL ON SYNTAX NAME connectionError  -- Set up error handling for the connection
  conn = DriverManager~getConnection(DB_URL)  -- Establish a connection to the SQLite database using the DB_URL attribute
  SIGNAL OFF SYNTAX  -- Turn off error handling
  say "Connection successful" -- Print a message indicating that the connection was successful
  say DB_URL -- Print the DB_URL attribute
  RETURN .true -- Return a true value to indicate that the connection was successful

/* Define the "insertData" method for the DatabaseHandler class, which inserts data into the SQLite database */
::METHOD insertData PUBLIC
  EXPOSE conn -- Allow access to the conn attribute
  -- Retrieve the values to be inserted as arguments
  USE ARG fname, lname, age, address, satisf
  -- Define the SQL query to insert the data
  query = "INSERT INTO Person (fname, lname, age, address, satisf) VALUES (?, ?, ?, ?, ?)"
  -- Prepare the SQL statement using the conn attribute
  statement = conn~prepareStatement(query)
  -- Bind the fname argument to the first "?" placeholder in the query
  statement~setString(1, fname)
  -- Bind the lname argument to the second "?" placeholder in the query
  statement~setString(2, lname)
  -- Bind the age argument to the third "?" placeholder in the query
  statement~setInt(3, age)
  -- Bind the address argument to the fourth "?" placeholder in the query
  statement~setString(4, address)
  -- Bind the satisf argument to the fifth "?" placeholder in the query
  statement~setString(5, satisf)
  -- Execute the SQL statement to insert the data into the SQLite database
  statement~execute


::REQUIRES "BSF.CLS"               -- Import the BSF.CLS file for use in the code
