::routine insertData public
  use arg slotDir
  scriptContext=slotDir~scriptContext -- Get the slotDir entry

  /* Get the values of the textfields and rating component */
  /* @get(textfieldFName) */
  /* @get(textfieldLName) */
  /* @get(textfield_age) */
  /* @get(textfieldAddress) */
  /* @get(rating) */
  /* @get(resultLabel) */

  /* Assign the values to variables */
  fname = textfieldFName~text
  lname = textfieldLName~text
  age = textfield_age~text
  address = textfieldAddress~text
  ratingValue = rating~getRating


  if fname="" | lname="" | age="" | address="" then do -- check if the fields have been filled out
    resultLabel~text = "Please fill out all fields."
    return -- exit the method
    end

  /* Call the insertData method of the DatabaseHandler instance */
  .my.app~dbh~insertData(fname,lname,age,address,ratingValue)

  /* Require the DatabaseHandler and BSF classes */
  ::REQUIRES "DatabaseHandler.CLS"
  ::REQUIRES "BSF.CLS"
