-- change directory to program location such that relatively addressed resources can be found
parse source  . . pgm
call directory filespec('L', pgm)   -- change to the directory where the program resides

-- set up application environment
.environment~setEntry("my.app", .directory~new)
.my.app~homeDir = filespec('Location',fullPath)
.my.app~dbh = .DatabaseHandler~new
.my.app~dbh~initSettings

-- connect to the database and handle connection errors
success = .my.app~dbh~connect
IF \success THEN CALL connectionError
else say "The Connection to the DB was successful!"

-- create Rexx object that will control the FXML set up
rxApp=.Formular~new
jrxApp=BSFCreateRexxProxy(rxApp, ,"javafx.application.Application")
jrxApp~launch(jrxApp~getClass, .nil)    -- launch the application, invokes "start"

EXIT 0

connectionError:
say "No Connection to the DB"


::REQUIRES "DatabaseHandler.CLS"
::REQUIRES "BSF.CLS"


-- Rexx class defines "javafx.application.Application" abstract method "start"
::class Formular -- implements the abstract class "javafx.application.Application"

-- Rexx method "start" implements the abstract method
::method start
  use arg primaryStage  -- fetch the primary stage (window)
  primaryStage~setTitle("Formular")

  -- create an URL for the FMXLDocument.fxml file (hence the protocol "file:")
  fxmlUrl=.bsf~new("java.net.URL", "file:gui.fxml")
  -- use FXMLLoader to load the FXML and create the GUI graph from its definitions:
  rootNode=bsf.loadClass("javafx.fxml.FXMLLoader")~load(fxmlUrl)

  scene=.bsf~new("javafx.scene.Scene", rootNode)    -- create a scene for the document
  primaryStage~setScene(scene)  -- set the stage to the scene
  primaryStage~show             -- show the stage (and thereby the scene)

