::routine CalculateBMI public
  slotDir=arg(arg())  -- note: last argument is the slotDir argument from BSF4ooRexx

/* RexxScript annotation fetches "TextField" from ScriptContext
     and makes it available as the Rexx variable "TEXTFIELD":  */
  /* @get(weightField) */
  /* @get(heightField) */
  /* @get(resultLabel) */
weightInput = weightField~text -- get the value of the first text field
heightInput = heightField~text -- get the value of the second text field

if weightInput="" | heightInput="" then do -- check if both fields have been filled out
    resultLabel~text = "Please enter the weight and height."
    return -- exit the method
    end

    --Calculate BMI
    weight = weightInput
    height = heightInput
    bmi = weight / (height * height)


    --Determine BMI category
    if bmi < 18.5 then
        category = "Underweight"
    else if bmi < 25 then
        category = "Normalweight"
    else
        category = "Overweight"

-- Output the result
/* RexxScript annotation fetches "label" from ScriptContext
and makes it available as the Rexx variable "LABEL": */
/* @get(resultLabel) */
resultLabel~text = "Your BMI is " || bmi~format(, "0.00") || " and you have " || category || "."


