--Change directory to program location so that relatively addressed resources can be found
parse source  . . pgm
call directory filespec('L', pgm)

rxApp=.BMICalculator~new -- create Rexx object that will control the FXML set up
jrxApp=BSFCreateRexxProxy(rxApp, ,"javafx.application.Application")
jrxApp~launch(jrxApp~getClass, .nil)  --Launch the application and invoke the "start" method

--Require the BSF and rxregexp classes for Java support
::requires "BSF.CLS"


--Define the Rexx class that implements the abstract class "javafx.application.Application"
::class BMICalculator

--Implement the "start" method to create and show the BMI Calculator GUI
::method start
  use arg primaryStage  -- fetch the primary stage (window)
  primaryStage~setTitle("BMI Calculator") -- Set the title of the primary stage

--Create an URL for the FMXLDocument.fxml file with the "file:" protocol
  fxmlUrl=.bsf~new("java.net.URL", "file:Gui.fxml")
--Use the FXMLLoader to load the FXML and create the GUI graph from its definitions
  rootNode=bsf.loadClass("javafx.fxml.FXMLLoader")~load(fxmlUrl)

  scene=.bsf~new("javafx.scene.Scene", rootNode)    -- create a scene for the document
  primaryStage~setScene(scene)  -- Set the primary stage to the scene
  primaryStage~show             -- Show the primary stage and the scene


