-- This routine opens the BMI calculator window
::routine openBMICalculator public
  use arg slotDir
  scriptContext=slotDir~scriptContext
  URL = "file:bmi_calculator.fxml"
  .my.app~stageHandler~newWindow("BMI-Calculator", URL)

-- This routine opens the calorie requirement window
::routine openCalorieRequirement public
  use arg slotDir
  scriptContext=slotDir~scriptContext
  URL = "file:calorieRequirement.fxml"
  .my.app~stageHandler~newWindow("Calorie Requirement", URL)

/*The routine calculates the BMI based on the weight and height values entered by the user.*/
::routine calculateBMI public
  use arg slotDir

/* RexxScript annotation fetches "TextField" from ScriptContext
     and makes it available as the Rexx variable "TEXTFIELD":  */
  /* @get(slider_weight) */
  /* @get(textField_height) */
weightInput = slider_weight~getValue -- get the value of the first text field
heightInput = textField_height~text -- get the value of the second text field

if heightInput="" then do -- check if the height field have been filled out
    -- Output the result
        /* RexxScript annotation fetches "label" from ScriptContext
        and makes it available as the Rexx variable "LABEL": */
        /* @get(resultLabel) */
        resultLabel~text = "Please enter a height."
    return -- exit the method
    end

    --Calculate BMI
    weight = weightInput
    height = heightInput
    bmi = weight / (height * height)


    --Determine BMI category
    if bmi < 18.5 then
        category = "underweight"
    else if bmi < 25 then
        category = "normalweight"
    else
        category = "overweight"

    -- Output the result
    /* RexxScript annotation fetches "label" from ScriptContext
    and makes it available as the Rexx variable "LABEL": */
    /* @get(resultLabel) */
    resultLabel~text = "Your BMI is " || bmi~format(, "0.00") || " and you have " || category || "."

/*The routine calculates the daily calorie requirement based on the weight, height, and age values entered by the user.*/
::routine calculateCalorieRequirment public
  use arg slotDir

/* RexxScript annotation fetches "TextField" from ScriptContext
     and makes it available as the Rexx variable "TEXTFIELD":  */
  /* @get(slider_weight) */
  /* @get(textField_height) */
  /* @get(slider_age) */
weightInput = slider_weight~getValue -- get the value of the first text field
heightInput = textField_height~text -- get the value of the second text field
ageInput = slider_age~getValue

if heightInput="" then do -- check if both fields have been filled out
    -- Output the result
        /* RexxScript annotation fetches "label" from ScriptContext
        and makes it available as the Rexx variable "LABEL": */
        /* @get(resultLabel) */
        resultLabel~text = "Please enter a height."
    return -- exit the method
    end

    --Calculate Calorie Requirement
    weight = weightInput
    height = heightInput*100
    age = ageInput

    calorieRequirment = 655.1 + (9.6 * weight) + (1.8 * height) - (4.7 * age)


    -- Output the result
    /* RexxScript annotation fetches "label" from ScriptContext
    and makes it available as the Rexx variable "LABEL": */
    /* @get(resultLabel) */
    resultLabel~text = "Your Calorie Requirment is " calorieRequirment~format(, "0") " kcal. "

::REQUIRES "BSF.CLS"
