/* Parse the source and get the full path */
PARSE SOURCE . . fullPath
CALL directory filespec('L', fullPath)

.environment~setEntry("my.app", .directory~new) --Set the environment variable 'my.app'
.my.app~homeDir = filespec('Location',fullPath) --Set the home directory of the application

stageHandler = .StageHandler~new --Create a new StageHandler object
.my.app~stageHandler = stageHandler --Set the stageHandler of the application
--Create a StageHandlerProxy object
stageHandlerProxy = BsfCreateRexxProxy(stageHandler,,"javafx.application.Application")
--Launch the application
stageHandlerProxy~launch(stageHandlerProxy~getClass, .nil)

/* Exit the program */
EXIT 0

/* Define the StageHandler class */
::CLASS StageHandler

/* Define the methods of the StageHandler class */
::METHOD stage ATTRIBUTE
::METHOD scene ATTRIBUTE
::METHOD windowStage ATTRIBUTE
::METHOD FXMLLoader
::METHOD init
  EXPOSE FXMLLoader

  FXMLLoader = bsf.import("javafx.fxml.FXMLLoader") --Import the FXMLLoader class

::METHOD start
  EXPOSE stage scene FXMLLoader
  USE ARG stage --Get the stage object

  stage~setTitle("Health Calculator") --Set the title of the stage

  /* Load the FXML file */
  url=.bsf~new("java.net.URL", "file:main_window.fxml")
  fxml = FXMLLoader~load(url)

  scene = .bsf~new("javafx.scene.Scene", fxml) --Create a new Scene
  stage~setScene(scene) --Set the Scene of the stage
  stage~show --Show the stage

::METHOD newWindow
  EXPOSE stage windowStage FXMLLoader
  USE ARG title, fileName --Get the title and file name

  windowStage = .bsf~new("javafx.stage.Stage") --Create a new window stage
  windowStage~setTitle(title) --Set the title of the window stage

  /* Load the FXML file */
  url =.bsf~new("java.net.URL", fileName)
  fxml = FXMLLoader~load(url)

  scene = .bsf~new("javafx.scene.Scene", fxml) --Create a new Scene
  windowStage~setScene(scene) --Set the Scene of the window stage
  windowStage~show --Show the window stage

::REQUIRES "BSF.CLS" -- get Java support
