rxApp=.BMICalculator~new -- create an instance of the Rexx class

-- rxApp will be used for "javafx.application.Application"
jrxApp=BSFCreateRexxProxy(rxApp, ,"javafx.application.Application")
jrxApp~launch(jrxApp~getClass, .nil) -- launch the application, invokes "start"

::requires "BSF.CLS" -- get Java support

-- Rexx class defines "javafx.application.Application" abstract method "start"
::class BMICalculator -- implements the abstract class "javafx.application.Application"
::method start -- Rexx method "start" implements the abstract method
use arg primaryStage -- fetch the primary stage (window)

primaryStage~setTitle("BMI Calculator") -- set the title of the window

root=.bsf~new("javafx.scene.layout.VBox") -- create the root node
root~prefHeight=400 -- set the preferred height of the VBox
root~prefWidth=400 -- set the preferred width of the VBox
root~setSpacing(20) -- set the spacing between nodes in the VBox

-- create two text fields for user input
weightField=.bsf~new("javafx.scene.control.TextField")
weightField~setPromptText("50.0")
heightField=.bsf~new("javafx.scene.control.TextField")
heightField~setPromptText("1.60")

-- create a label for the weight field
weightLabel=.bsf~new("javafx.scene.control.Label")
weightLabel~text("Enter your weight (kg):")

-- create a label for the height field
heightLabel=.bsf~new("javafx.scene.control.Label")
heightLabel~text("Enter your height (m):")

-- create a button for performing the BMI calculation
calculateBtn=.bsf~new("javafx.scene.control.Button")
calculateBtn~text="Calculate BMI"

-- create a label for displaying the result
resultLabel=.bsf~new("javafx.scene.control.Label")

/* add the weight label, weight field, height label,
height field, calculate button, and result label to the VBox*/
root~getChildren~~add(weightLabel)~~add(weightField)~~add(heightLabel)
root~getChildren~~add(heightField)~~add(calculateBtn)~~add(resultLabel)
-- put the VBox on the stage
primaryStage~setScene(.bsf~new("javafx.scene.Scene", root))

primaryStage~show -- show the stage (window) with the scene

-- create a Rexx object to handle button presses
handler=.RexxButtonHandler~new(weightField, heightField, resultLabel)

-- create a Rexx proxy object to forward button events to the Rexx object
jrh=BSFCreateRexxProxy(handler, ,"javafx.event.EventHandler")

-- set the button's action handler to the Rexx proxy object
calculateBtn~setOnAction(jrh)

-- Rexx class which handles the button presses
::class RexxButtonHandler -- implements "javafx.event.EventHandler" interface
::method init -- Rexx constructor method
    expose weightField heightField resultLabel  -- allow direct access to ooRexx attribute
    use arg weightField, heightField, resultLabel
-- save reference to javafx.scene.control.Label

::method handle -- will be invoked by the Java side when the button is pressed
expose weightField heightField resultLabel-- allow direct access to ooRexx attribute
use arg event, slotDir -- expected arguments

weightInput = weightField~getText -- get the value of the first text field
heightInput = heightField~getText -- get the value of the second text field

if weightInput="" | heightInput="" then do -- check if both fields have been filled out
    resultLabel~text = "Please enter the weight and height."
    return -- exit the method
    end

--Calculate BMI
weight = weightInput
height = heightInput
bmi = weight / (height * height)

--Determine BMI category
if bmi < 18.5 then
    category = "Underweight"
else if bmi < 25 then
    category = "Normalweight"
else
    category = "Overweight"

-- Output the result
resultLabel~text = "Your BMI is" bmi~format(, "0.00") "and you have " category "."


