/* Main program */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database folder already there"
if ret = 0 then say "Database folder successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;

/* Pass url to db_conn routine */
conn = db_conn(url)

/* Creates statement object for SQL commands */
statement=conn~createStatement

/* Execute CREATE TABLE statement */
rSet = statement~executeUpdate("CREATE TABLE IF NOT EXISTS animals" -
"('animal_id' TEXT, 'name' TEXT, 'weight' TEXT);")
/* Define new array */
animalslist = .Array~new
/* Fill array with values */
animalslist = ('lowe', 'totenkopfaffe', 'giraffe', 'burchell-zebra', 'felsenpinguin')~makeArray
/* "Start of Transaction" */
rSet = statement~executeUpdate("BEGIN TRANSACTION;")
/* Iterate over array */
loop animal over animalslist
    /* Execute INSERT statement, get weight and unit from animalWeight routine */
    rSet = statement~executeUpdate("INSERT INTO animals" -
    "(animal_id, weight) VALUES ('"animal||"','"animalWeight(animal)"');")
end

/* Call routine to check if inserts were successful */
CALL showTable animals, conn
/* Rollback, changes are not saved */
rSet = statement~executeUpdate("ROLLBACK;")
SAY rollback
/* Check if inserts are gone */
CALL showTable animals, conn
/* Delete table, rSet should be 0 */
rSet = statement~executeUpdate("DROP TABLE animals;")
IF rSet = 0 THEN SAY table dropped

/* Close database connection */
conn~close
/* End program */
exit
/* End main program */

/* Get animal weight */
::ROUTINE animalWeight
    USE ARG animal
    /* Curl zoo website */
    command="curl https://www.zoovienna.at/tiere/saeugetiere/"||animal~lower||"/"
    /* Create array to store output */
    outArr=.array~new
    /* Create array for error messages */
    errArr=.array~new
    /* Give command to operating system */
    ADDRESS SYSTEM command WITH OUTPUT USING (outArr) ERROR USING (errArr)
    /* Parse only weight */
    parse VAR outArr '"animal-fact-list__headline">Gewicht</span><span>' bis weight unit "</span>"
    /* Check format and adapt */
    if bis~datatype(numeric) then do
        unit = weight
        weight = bis
    end
    say animal||": " weight unit
/* Return weight and unit of animal */
RETURN weight unit

::REQUIRES zoodbtools.rexx
::REQUIRES BSF.CLS