/* This program creates the tables "animals" and "inhabitants"
in the SQLite Database "zoo.db" */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database folder already there"
if ret = 0 then say "Database folder successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;

/* Pass url to db_conn routine */
conn = db_conn(url)

/* Creates statement object for SQL commands */
statement=conn~createStatement

/* Execute CREATE TABLE statement */
rSet = statement~executeUpdate("CREATE TABLE IF NOT EXISTS animals" -
"('animal_id' TEXT, 'name' TEXT, 'weight' TEXT);")
/* Output when successful (rSet = 0) */
if rSet = 0 then say "Table 'animals' successfully created"

rSet = statement~executeUpdate("CREATE TABLE IF NOT EXISTS inhabitants" -
"('name' TEXT, 'animal' TEXT);")
/* Output when successful (rSet = 0) */
if rSet = 0 then say "Table 'inhabitants' successfully created"

/* Call routine to show table graphically */
CALL showTable animals, conn
CALL showTable inhabitants, conn

/* Close database connection */
conn~close

::REQUIRES zoodbtools.rexx
::REQUIRES BSF.CLS