/* This program inserts data into the table "animals".
It is required to execute zoocreatetable before running this program. */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database file already there"
if ret = 0 then say "Database file successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;
/* Pass url to db_conn routine */
conn = db_conn(url)

/* Show table before insert statement */
SAY "Tables before"
CALL showTable animals, conn
CALL showTable inhabitants, conn

/* Prepare object preparedStatement with variables */
preparedStatement = conn~prepareStatement("INSERT INTO animals" -
"(animal_id, name, weight) VALUES (?, ?, ?)")

/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "lowe")
preparedStatement~setString(2, "lion")
preparedStatement~setString(3, "250 kg")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()
/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "totenkopfaffe")
preparedStatement~setString(2, "monkey")
preparedStatement~setString(3, "1 kg")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()
/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "giraffe")
preparedStatement~setString(2, "giraffe")
preparedStatement~setString(3, "1.200 kg")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()
/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "burchell-zebra")
preparedStatement~setString(2, "zebra")
preparedStatement~setString(3, "300 kg")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()
/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "felsenpinguin")
preparedStatement~setString(2, "penguin")
preparedStatement~setString(3, "2,5 kg")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()

/* Prepare object preparedStatement with variables */
preparedStatement = conn~prepareStatement("INSERT INTO inhabitants" -
"(name, animal) VALUES (?, ?)")

/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "Nico")
preparedStatement~setString(2, "lion")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()

/* Pass Values for the variables in the prepared statement */
preparedStatement~setString(1, "Pingi")
preparedStatement~setString(2, "penguin")
/* Execute prepared Statement */
rSet = preparedStatement~executeUpdate()

/* Call routine to show table graphically */
SAY "Tables after"
CALL showTable animals, conn
CALL showTable inhabitants, conn

/* Close database connection */
conn~close

::REQUIRES zoodbtools.rexx
::REQUIRES BSF.CLS