/* This program joins data from table "animals" and "inhabitants".
It is required to execute the following programs before running this program:
1) zoo1createtable
2) zoo2insert */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database file already there"
if ret = 0 then say "Database file successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;
/* Pass url to db_conn routine */
conn = db_conn(url)

/* Creates statement object for SQL commands */
statement=conn~createStatement

/* Execute SELECT query with LEFT JOIN */
rSet = statement~executeQuery("SELECT inhabitants.name, inhabitants.animal," -
"animals.weight FROM inhabitants LEFT JOIN animals ON animals.name =" -
"inhabitants.animal WHERE inhabitants.animal = 'lion';")

/* Call routine to show table graphically */
SAY "Joined Table"
CALL showJoin rSet

/* Close database connection */
conn~close

::ROUTINE showJoin
    /* Use result set for data output */
    USE ARG rSet
    /* Check if select successful */
    IF rSet <> 0 THEN
        DO
            SAY "JOIN: inhabitants LEFT JOIN animals ON" -
                "animals.name = inhabitants.animal WHERE inhabitants.animal = lion"
        END
    ELSE SAY "Error"
    /* Create outer and inner border, including spaces and separators */
    border.top = "="~copies(15*3+(3-1)*3+4)
    border.in = "-"~copies(15*3+(3-1)*3+4)
    /* Create header separator */
    header = "|"
    /* Iterate over 3 columns */
    DO i=1 TO 3
        header = header left("Field"||i, 15) "|"
    END
    /*Header output */
    say border.top
    say header
    say border.in

    /* Create data output */
    DO WHILE rset~next
        /* Create data separator */
        data = "|"
        DO i=1 TO 3
            /* Format data output */
            data = data left(rset~getString(i), 15) "|"
        END
        /* Data output */
        say data
    END
    say border.top

RETURN

::ROUTINE db_conn public
    /* Uses url to database */
    USE ARG url
    /* Create new object, load JDBC-driver class */
    mydriver=.bsf~new('org.sqlite.JDBC')
    /* Load class DriverManager */
    man=bsf.loadClass("java.sql.DriverManager")
    /* Register driver as driver manager */
    man~registerDriver(mydriver)
    /* Returns connection object */
    conn=man~getConnection(url)
    /* Creates statement object for SQL commands */
    --statement=conn~createStatement

    /* Check if connection works */
    if conn=0 then DO
        say Connection not successful
        EXIT
    END
    say Connection successful

/* Return statement object */
RETURN conn

::REQUIRES BSF.CLS