/* This program selects data from the table "animals".
It is required to execute the following programs before running this program:
1) zoo1createtable
2) zoo2insert */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database folder already there"
if ret = 0 then say "Database folder successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;

/* Pass url to db_conn routine */
conn = db_conn(url)

/* Creates statement object for SQL commands */
statement=conn~createStatement

rSet = statement~executeQuery("SELECT name, weight FROM animals;")

/* Call routine to show table graphically */
SAY "ANIMALS: Result of Select"
CALL showSelect rSet

/* Close database connection */
conn~close


::ROUTINE showSelect public
    /* Use table and statement for sql select */
    USE ARG rSet

    rSetMeta = rSet~getMetaData()
    columncount = rSetMeta~getColumnCount()

    /* Create outer and inner border, including spaces and separators */
    border.top = "="~copies(15*columncount+(columncount-1)*3+4)
    border.in = "-"~copies(15*columncount+(columncount-1)*3+4)
    /* Create header separator */
    header = "|"
    /* Get number of columns from routine getCols */
    DO i=1 TO columncount
        /* Get column names from routine tableInfo */
        header = header left(rSetMeta~getColumnName(i), 15) "|"
    END
    /* Header output */
    say border.top
    say header
    say border.in

    /* Create data output */
    DO WHILE rset~next
        /* Create data separator */
        data = "|"
        /* Use column number from routine getCols */
        DO i=1 TO columncount
            /* Format data output */
            data = data left(rset~getString(i), 15) "|"
        END
        /*Data output */
        say data
    END
    say border.top

RETURN



/* Establish connection to SQLite-database */
::ROUTINE db_conn public
    /* Uses url to database */
    USE ARG url
    /* Create new object, load JDBC-driver class */
    mydriver=.bsf~new('org.sqlite.JDBC')
    /* Load class DriverManager */
    man=bsf.loadClass("java.sql.DriverManager")
    /* Register driver as driver manager */
    man~registerDriver(mydriver)
    /* Returns connection object */
    conn=man~getConnection(url)

    /* Check if connection works */
    if conn=0 then DO
        say Connection not successful
        EXIT
    END
    say Connection successful

/* Return statement object */
RETURN conn

::REQUIRES BSF.CLS