/* This program deletes all data from "animals" and inhabitants,
but changes are followed by a "rollback"
It is required to execute the following programs before running this program:
1) zoo1createtable
2) zoo2insert */

/*Create directory for database */
homeDir=.java.lang.System~getProperty("user.home")
dbdir = "Database"
dbdirpath=homeDir ||"\"||dbdir
ret = sysMkDir(dbdirpath)
if ret = 183 then say "Database file already there"
if ret = 0 then say "Database file successfully created"

dbfile = "zoo.db"
dbfilepath = dbdirpath ||"\"||dbfile

/* Path to database */
url = "jdbc:sqlite:"||dbfilepath;

/* Pass url to db_conn routine */
conn = db_conn(url)

/* Creates statement object for SQL commands */
statement=conn~createStatement

/* Start of transaction */
rSet = statement~executeUpdate("BEGIN TRANSACTION;")

/* Execute DELETE statement */
rSet = statement~executeUpdate("DELETE FROM animals;")

rSet = statement~executeUpdate("DELETE FROM inhabitants;")

SAY "Tables before"
CALL showTable animals, conn
CALL showTable inhabitants, conn

/* End of transaction */
rSet = statement~executeUpdate("ROLLBACK;")
say "ROLLBACK"

/* Call routine to show table graphically */
SAY "Tables after rollback"
CALL showTable animals, conn
CALL showTable inhabitants, conn

/* Close database connection */
conn~close

::REQUIRES zoodbtools.rexx
::REQUIRES BSF.CLS