::ROUTINE showTable public
    /* Use table and statement for sql select */
    USE ARG table, conn
    /* Create statement object */
    statement=conn~createStatement

    /* Get column names from routine tableInfo */
    Attribute.List = tableInfo(table, statement)
    /* Execute SELECT statement */
    rSet = statement~executeQuery("SELECT * FROM" table ";")
    /* Create outer and inner border, including spaces and separators */
    border.top = "="~copies(15*getCols(rSet)+(getCols(rSet)-1)*3+4)
    border.in = "-"~copies(15*getCols(rSet)+(getCols(rSet)-1)*3+4)
    /* Create header separator */
    header = "|"
    /* Get number of columns from routine getCols */
    DO i=1 TO getCols(rSet)
        /* Get column names from routine tableInfo */
        header = header left(Attribute.List[i], 15) "|"
    END
    /* Print table name */
    SAY table
    /* Header output */
    say border.top
    say header
    say border.in

    /* Create data output */
    DO WHILE rset~next
        /* Create data separator */
        data = "|"
        /* Use column number from routine getCols */
        DO i=1 TO getCols(rSet)
            /* Format data output */
            data = data left(rset~getString(i), 15) "|"
        END
        /*Data output */
        say data
    END
    say border.top

RETURN

/* Get number of columns of table */
::ROUTINE getCols public
    /* Use resultset from select query */
    USE ARG res
    /* Stop when "done" is reached */
    SIGNAL ON ANY NAME done
    cols=0
    /* Get string from result set until the column doesn't exist --> Error */
    DO FOREVER
        cols+=1
        res~getString(cols)
    END
    done:
/* Return last successful column = number of columns */
return cols-1

/* Get column names */
::ROUTINE tableInfo public
    USE ARG table, statement
    /* Get info from pragma table */
    rSet=statement~executeQuery("Pragma table_xinfo(" table ");")
    /* Array for column names */
    Attribute.List=.Array~new

    DO WHILE rSet~next()
        /* Add name to array */
        Attribute.List~append(rSet~getString(2))
    END

RETURN Attribute.List

/* Establish connection to SQLite-database */
::ROUTINE db_conn public
    /* Uses url to database */
    USE ARG url
    /* Create new object, load JDBC-driver class */
    mydriver=.bsf~new('org.sqlite.JDBC')
    /* Load class DriverManager */
    man=bsf.loadClass("java.sql.DriverManager")
    /* Register driver as driver manager */
    man~registerDriver(mydriver)
    /* Returns connection object */
    conn=man~getConnection(url)

    if conn=0 then DO
        RAISE SYNTAX 91.900 additional "Connection to database failed"
    END
    say Connection successful

/* Return statement object */
RETURN conn

::REQUIRES BSF.CLS