/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.controlsfx.glyphfont.GlyphFont;

public final class GlyphFontRegistry {
    private static Map<String, GlyphFont> fontMap = new HashMap<String, GlyphFont>();

    private GlyphFontRegistry() {
    }

    public static void register(String familyName, String uri, int defaultSize) {
        GlyphFontRegistry.register(new GlyphFont(familyName, defaultSize, uri));
    }

    public static void register(String familyName, InputStream in, int defaultSize) {
        GlyphFontRegistry.register(new GlyphFont(familyName, defaultSize, in));
    }

    public static void register(GlyphFont font) {
        if (font != null) {
            fontMap.put(font.getName(), font);
        }
    }

    public static GlyphFont font(String familyName) {
        GlyphFont font = fontMap.get(familyName);
        if (font != null) {
            font.ensureFontIsLoaded();
        }
        return font;
    }

    static {
        ServiceLoader<GlyphFont> loader = ServiceLoader.load(GlyphFont.class);
        for (GlyphFont font : loader) {
            GlyphFontRegistry.register(font);
        }
    }
}

