/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSF_Log;
import org.apache.bsf.BSF_LogFactory;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.ObjectRegistry;

public class BSFManager {
    protected static String version = "245.20130629";
    protected static Hashtable registeredEngines = new Hashtable();
    protected static Hashtable extn2Lang = new Hashtable();
    protected static ClassLoader definedClassLoader;
    protected Hashtable loadedEngines = new Hashtable();
    protected ObjectRegistry objectRegistry = new ObjectRegistry();
    protected PropertyChangeSupport pcs;
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected String tempDir = ".";
    protected String classPath;
    protected Vector declaredBeans = new Vector();
    private BSF_Log logger = null;

    public static ClassLoader getDefinedClassLoader() {
        return definedClassLoader;
    }

    public BSFManager() {
        this.pcs = new PropertyChangeSupport(this);
        this.logger = BSF_LogFactory.getLog(this.getClass().getName());
    }

    public static String getVersion() {
        return version;
    }

    public Object apply(String string, String string2, int n, int n2, Object object, Vector vector, Vector vector2) throws BSFException {
        this.logger.debug("BSFManager:apply");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final Vector vector3 = vector;
        final Vector vector4 = vector2;
        Object var15_15 = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return bSFEngine.apply(string3, n3, n4, object2, vector3, vector4);
                }
            });
            var15_15 = t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception: ", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
        return var15_15;
    }

    public void compileApply(String string, String string2, int n, int n2, Object object, Vector vector, Vector vector2, CodeBuffer codeBuffer) throws BSFException {
        this.logger.debug("BSFManager:compileApply");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final Vector vector3 = vector;
        final Vector vector4 = vector2;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileApply(string3, n3, n4, object2, vector3, vector4, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void compileExpr(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        this.logger.debug("BSFManager:compileExpr");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileExpr(string3, n3, n4, object2, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void compileScript(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        this.logger.debug("BSFManager:compileScript");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        final CodeBuffer codeBuffer2 = codeBuffer;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.compileScript(string3, n3, n4, object2, codeBuffer2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void declareBean(String string, Object object, Class clazz) throws BSFException {
        this.logger.debug("BSFManager:declareBean");
        this.registerBean(string, object);
        BSFDeclaredBean bSFDeclaredBean = new BSFDeclaredBean(string, object, clazz);
        this.declaredBeans.addElement(bSFDeclaredBean);
        Enumeration enumeration = this.loadedEngines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            bSFEngine.declareBean(bSFDeclaredBean);
        }
    }

    public Object eval(String string, String string2, int n, int n2, Object object) throws BSFException {
        this.logger.debug("BSFManager:eval");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        Object var11_11 = null;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return bSFEngine.eval(string3, n3, n4, object2);
                }
            });
            var11_11 = t;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception: ", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
        return var11_11;
    }

    public void exec(String string, String string2, int n, int n2, Object object) throws BSFException {
        this.logger.debug("BSFManager:exec");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.exec(string3, n3, n4, object2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public void iexec(String string, String string2, int n, int n2, Object object) throws BSFException {
        this.logger.debug("BSFManager:iexec");
        final BSFEngine bSFEngine = this.loadScriptingEngine(string);
        final String string3 = string2;
        final int n3 = n;
        final int n4 = n2;
        final Object object2 = object;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine.iexec(string3, n3, n4, object2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
    }

    public ClassLoader getClassLoader() {
        this.logger.debug("BSFManager:getClassLoader");
        return this.classLoader;
    }

    public String getClassPath() {
        this.logger.debug("BSFManager:getClassPath");
        if (this.classPath == null) {
            try {
                this.classPath = System.getProperty("java.class.path");
            }
            catch (Throwable throwable) {
                this.logger.debug("[BSFManager] Exception :", throwable);
            }
        }
        return this.classPath;
    }

    public static String getLangFromFilename(String string) throws BSFException {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            String string3 = (String)extn2Lang.get(string2);
            String string4 = null;
            int n2 = 0;
            if (string3 != null) {
                int n3;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                while ((n3 = string3.indexOf(":", 0)) != -1) {
                    string4 = string3.substring(0, n3);
                    string3 = string3.substring(n3 + 1);
                    ++n2;
                    String string5 = null;
                    try {
                        string5 = (String)registeredEngines.get(string4);
                        boolean bl = false;
                        if (classLoader != null) {
                            try {
                                classLoader.loadClass(string5);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                bl = true;
                            }
                        }
                        if (!bl && classLoader != null) break;
                        definedClassLoader.loadClass(string5);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string4 = string3;
                    }
                }
                if (n2 == 0) {
                    string4 = string3;
                }
            }
            if (string4 != null && string4 != "") {
                return string4;
            }
        }
        throw new BSFException(500, "[BSFManager.getLangFromFilename] file extension missing or unknown: unable to determine language for '" + string + "'");
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public static boolean isLanguageRegistered(String string) {
        return registeredEngines.get(string) != null;
    }

    public BSFEngine loadScriptingEngine(String string) throws BSFException {
        this.logger.debug("BSFManager:loadScriptingEngine");
        BSFEngine bSFEngine = (BSFEngine)this.loadedEngines.get(string);
        if (bSFEngine != null) {
            return bSFEngine;
        }
        String string2 = (String)registeredEngines.get(string);
        if (string2 == null) {
            this.logger.error("[BSFManager] unsupported language: " + string);
            throw new BSFException(20, "[BSFManager.loadScriptingEngine()] unsupported language: " + string);
        }
        try {
            Class<?> clazz = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = definedClassLoader.loadClass(string2);
            }
            final BSFEngine bSFEngine2 = (BSFEngine)clazz.newInstance();
            final BSFManager bSFManager = this;
            final String string3 = string;
            final Vector vector = this.declaredBeans;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    bSFEngine2.initialize(bSFManager, string3, vector);
                    return null;
                }
            });
            bSFEngine = bSFEngine2;
            this.loadedEngines.put(string, bSFEngine);
            this.pcs.addPropertyChangeListener(bSFEngine);
            return bSFEngine;
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.logger.error("[BSFManager] Exception :", privilegedActionException);
            throw (BSFException)privilegedActionException.getException();
        }
        catch (Throwable throwable) {
            this.logger.error("[BSFManager] Exception :", throwable);
            throw new BSFException(500, "[BSFManager.loadScriptingEngine()] unable to load language: " + string, throwable);
        }
    }

    public Object lookupBean(String string) {
        this.logger.debug("BSFManager:lookupBean");
        try {
            return ((BSFDeclaredBean)this.objectRegistry.lookup((String)string)).bean;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.debug("[BSFManager] Exception :", illegalArgumentException);
            return null;
        }
    }

    public void registerBean(String string, Object object) {
        this.logger.debug("BSFManager:registerBean");
        BSFDeclaredBean bSFDeclaredBean = object == null ? new BSFDeclaredBean(string, null, null) : new BSFDeclaredBean(string, object, object.getClass());
        this.objectRegistry.register(string, bSFDeclaredBean);
    }

    public static void registerScriptingEngine(String string, String string2, String[] stringArray) {
        registeredEngines.put(string, string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = (String)extn2Lang.get(stringArray[i]);
                string3 = string3 == null ? string : string + ":" + string3;
                extn2Lang.put(stringArray[i], string3);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.logger.debug("BSFManager:setClassLoader");
        this.pcs.firePropertyChange("classLoader", this.classLoader, classLoader);
        this.classLoader = classLoader;
    }

    public void setClassPath(String string) {
        this.logger.debug("BSFManager:setClassPath");
        this.pcs.firePropertyChange("classPath", this.classPath, string);
        this.classPath = string;
    }

    public void setObjectRegistry(ObjectRegistry objectRegistry) {
        this.logger.debug("BSFManager:setObjectRegistry");
        this.objectRegistry = objectRegistry;
    }

    public void setTempDir(String string) {
        this.logger.debug("BSFManager:setTempDir");
        this.pcs.firePropertyChange("tempDir", this.tempDir, string);
        this.tempDir = string;
    }

    public void terminate() {
        this.logger.debug("BSFManager:terminate");
        Enumeration enumeration = this.loadedEngines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            this.pcs.removePropertyChangeListener(bSFEngine);
            bSFEngine.terminate();
        }
        this.loadedEngines = new Hashtable();
    }

    public void undeclareBean(String string) throws BSFException {
        this.logger.debug("BSFManager:undeclareBean");
        this.unregisterBean(string);
        BSFDeclaredBean bSFDeclaredBean2 = null;
        boolean bl = false;
        for (BSFDeclaredBean bSFDeclaredBean2 : this.declaredBeans) {
            if (!bSFDeclaredBean2.name.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.declaredBeans.removeElement(bSFDeclaredBean2);
            Enumeration enumeration = this.loadedEngines.elements();
            while (enumeration.hasMoreElements()) {
                BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
                bSFEngine.undeclareBean(bSFDeclaredBean2);
            }
        }
    }

    public void unregisterBean(String string) {
        this.logger.debug("BSFManager:unregisterBean");
        this.objectRegistry.unregister(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = "org.apache.bsf.BSFManager.dumpEnvironment() [from static{}]";
        try {
            definedClassLoader = BSFManager.class.getClassLoader();
            String string2 = "org/apache/bsf/Languages.properties";
            Enumeration<URL> enumeration = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                enumeration = classLoader.getResources(string2);
            } else {
                enumeration = definedClassLoader.getResources(string2);
                Thread.currentThread().setContextClassLoader(definedClassLoader);
            }
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                Properties properties = new Properties();
                properties.load(inputStream);
                Enumeration<?> enumeration2 = properties.propertyNames();
                while (enumeration2.hasMoreElements()) {
                    String string3 = (String)enumeration2.nextElement();
                    String string4 = properties.getProperty(string3);
                    String string5 = string4.substring(0, string4.indexOf(","));
                    String string6 = string4.substring(string4.indexOf(",") + 1, string4.length());
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, "|");
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        stringArray[n] = stringTokenizer.nextToken().trim();
                        ++n;
                    }
                    BSFManager.registerScriptingEngine(string3, string5, stringArray);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Error reading Languages file " + iOException);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            System.err.println("Syntax error in Languages resource bundle");
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.err.println("Initialization error: " + missingResourceException.toString());
        }
    }
}

