/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.netrexx;

import COM.ibm.netrexx.process.NetRexxC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.BadArgumentException;
import netrexx.lang.Rexx;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.BSF_Log;
import org.apache.bsf.BSF_LogFactory;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.apache.bsf.util.EngineUtils;
import org.apache.bsf.util.MethodUtils;
import org.apache.bsf.util.StringUtils;

public class NetRexxEngine
extends BSFEngineImpl {
    BSFFunctions mgrfuncs;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private BSF_Log logger = BSF_LogFactory.getLog(this.getClass().getName());
    private static int uniqueFileOffset = 0;

    public NetRexxEngine() {
        new BadArgumentException();
    }

    @Override
    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        throw new BSFException(499, "NetRexx doesn't currently support call()", null);
    }

    Object callStatic(Class clazz, String string, Object[] objectArray) throws BSFException {
        Object object = null;
        try {
            if (clazz != null) {
                Class[] classArray = new Class[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    classArray[i] = objectArray[i].getClass();
                }
                Method method = MethodUtils.getMethod(clazz, string, classArray);
                object = method.invoke(null, objectArray);
            } else {
                this.logger.error("NetRexxEngine: ERROR: rexxclass==null!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                throwable.printStackTrace();
            }
            throw new BSFException(10, exception.getMessage(), exception);
        }
        return object;
    }

    @Override
    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
    }

    @Override
    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        return this.execEvalShared(string, n, n2, object, true);
    }

    @Override
    public void exec(String string, int n, int n2, Object object) throws BSFException {
        this.execEvalShared(string, n, n2, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object execEvalShared(String string, int n, int n2, Object object, boolean bl) throws BSFException {
        int n3;
        Object object2;
        String string2;
        Object object3;
        block29: {
            String string3;
            object3 = null;
            string2 = null;
            GeneratedFile generatedFile = null;
            Class clazz = null;
            String string4 = string3 = object.toString();
            try {
                clazz = (Class)codeToClass.get(string3);
                if (clazz != null) {
                    this.logger.debug("NetRexxEngine: Found pre-compiled class for script '" + string3 + "'");
                    string2 = clazz.getName();
                } else {
                    Object object4;
                    generatedFile = this.openUniqueFile(this.tempDir, "BSFNetRexx", ".nrx");
                    if (generatedFile == null) {
                        throw new BSFException("couldn't create NetRexx scratchfile");
                    }
                    string2 = generatedFile.className;
                    object2 = "";
                    if (bl) {
                        object2 = "returns java.lang.Object";
                    }
                    generatedFile.fos.write(("class " + string2 + ";\n").getBytes());
                    generatedFile.fos.write(("method BSFNetRexxEngineEntry(bsf=org.apache.bsf.util.BSFFunctions)  public static " + (String)object2 + ";\n").getBytes());
                    int n4 = string4.indexOf(placeholder);
                    if (n4 >= 0) {
                        object4 = new StringBuffer();
                        while (n4 >= 0) {
                            ((StringBuffer)object4).setLength(0);
                            if (n4 > 0) {
                                ((StringBuffer)object4).append(string4.substring(0, n4));
                            }
                            ((StringBuffer)object4).append(string2);
                            n3 = n4 + placeholder.length();
                            if (n3 < string4.length()) {
                                ((StringBuffer)object4).append(string4.substring(n3));
                            }
                            string4 = ((StringBuffer)object4).toString();
                            n4 = string4.indexOf(placeholder, n4);
                        }
                    }
                    for (int i = 0; i < this.declaredBeans.size(); ++i) {
                        object4 = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
                        String string5 = StringUtils.getClassName(((BSFDeclaredBean)object4).type);
                        generatedFile.fos.write((((BSFDeclaredBean)object4).name + " =" + string5 + "   bsf.lookupBean(\"" + ((BSFDeclaredBean)object4).name + "\");").getBytes());
                    }
                    if (bl) {
                        generatedFile.fos.write("return ".getBytes());
                    }
                    generatedFile.fos.write(string4.getBytes());
                    generatedFile.fos.close();
                    this.logger.debug("NetRexxEngine: wrote temp file " + generatedFile.file.getPath() + ", now compiling");
                    String string6 = generatedFile.file.getPath();
                    if (this.logger.isDebugEnabled()) {
                        string6 = string6 + " -verbose4";
                    } else {
                        string6 = string6 + " -noverbose";
                        string6 = string6 + " -noconsole";
                    }
                    Rexx rexx = new Rexx(string6);
                    String string7 = serializeCompilation;
                    // MONITORENTER : string7
                    int n5 = NetRexxC.main((Rexx)rexx, (PrintWriter)new PrintWriter(System.err));
                    // MONITOREXIT : string7
                    if (n5 == 2) {
                        throw new BSFException(100, "There were NetRexx errors.");
                    }
                    this.logger.debug("NetRexxEngine: loading class " + string2);
                    clazz = EngineUtils.loadClass(this.mgr, string2);
                    codeToClass.put(string3, clazz);
                }
                object2 = new Object[]{this.mgrfuncs};
                object3 = this.callStatic(clazz, "BSFNetRexxEngineEntry", (Object[])object2);
                if (generatedFile == null || generatedFile.file == null || !generatedFile.file.exists()) break block29;
                generatedFile.file.delete();
            }
            catch (BSFException bSFException) {
                try {
                    throw bSFException;
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (!(exception instanceof InvocationTargetException)) throw new BSFException(10, exception.getMessage(), exception);
                        Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                        throwable.printStackTrace();
                        throw new BSFException(10, exception.getMessage(), exception);
                    }
                }
                catch (Throwable throwable) {
                    if (generatedFile != null && generatedFile.file != null && generatedFile.file.exists()) {
                        generatedFile.file.delete();
                    }
                    if (string2 == null) throw throwable;
                    File file = new File(this.tempDir + File.separatorChar + string2 + ".java");
                    if (file.exists()) {
                        file.delete();
                    }
                    if ((file = new File(string2 + ".class")).exists()) {
                        file.delete();
                    }
                    if ((file = new File(this.tempDir + File.separatorChar + string2 + ".crossref")).exists()) {
                        file.delete();
                    }
                    file = new File(this.tempDir);
                    this.minorPrefix = string2 + "$";
                    String[] stringArray = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return 0 == string.indexOf(NetRexxEngine.this.minorPrefix) && string.lastIndexOf(".class") == string.length() - 6;
                        }
                    });
                    if (stringArray == null) throw throwable;
                    int n6 = stringArray.length;
                    while (n6 > 0) {
                        file = new File(stringArray[--n6]);
                        file.delete();
                    }
                    throw throwable;
                }
            }
        }
        if (string2 == null) return object3;
        object2 = new File(this.tempDir + File.separatorChar + string2 + ".java");
        if (((File)object2).exists()) {
            ((File)object2).delete();
        }
        if (((File)(object2 = new File(string2 + ".class"))).exists()) {
            ((File)object2).delete();
        }
        if (((File)(object2 = new File(this.tempDir + File.separatorChar + string2 + ".crossref"))).exists()) {
            ((File)object2).delete();
        }
        object2 = new File(this.tempDir);
        this.minorPrefix = string2 + "$";
        String[] stringArray = ((File)object2).list(new /* invalid duplicate definition of identical inner class */);
        if (stringArray == null) return object3;
        n3 = stringArray.length;
        while (n3 > 0) {
            object2 = new File(stringArray[--n3]);
            ((File)object2).delete();
        }
        return object3;
    }

    @Override
    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.mgrfuncs = new BSFFunctions(bSFManager, this);
    }

    private GeneratedFile openUniqueFile(String string, String string2, String string3) {
        File file = null;
        File file2 = null;
        FileOutputStream fileOutputStream = null;
        int n = 1000;
        GeneratedFile generatedFile = null;
        String string4 = null;
        int n2 = n;
        ++uniqueFileOffset;
        while (fileOutputStream == null && n2 > 0) {
            block6: {
                try {
                    string4 = string2 + uniqueFileOffset;
                    file = new File(string + File.separatorChar + string4 + string3);
                    file2 = new File(string + File.separatorChar + string4 + ".class");
                    if (file != null && !file.exists() & file2 != null & !file2.exists()) {
                        fileOutputStream = new FileOutputStream(file);
                    }
                }
                catch (Exception exception) {
                    if (file.exists()) break block6;
                    this.logger.error("openUniqueFile: unexpected " + exception);
                }
            }
            --n2;
            ++uniqueFileOffset;
        }
        if (fileOutputStream == null) {
            this.logger.error("openUniqueFile: Failed " + n + "attempts.");
        } else {
            generatedFile = new GeneratedFile(file, fileOutputStream, string4);
        }
        return generatedFile;
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fileOutputStream, String string) {
            this.file = file;
            this.fos = fileOutputStream;
            this.className = string;
        }
    }
}

