/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.test.utilTests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.bsf.util.StringUtils;

public class StringUtilsTest
extends TestCase {
    private static final String lineSeparator = System.getProperty("line.separator", "\n");

    public StringUtilsTest(String string) {
        super(string);
    }

    public void testClassNameToVarName() {
        StringUtilsTest.assertTrue((boolean)StringUtils.classNameToVarName("int").equals(new String("int")));
        StringUtilsTest.assertTrue((boolean)StringUtils.classNameToVarName("int[][][]").equals(new String("int_3D")));
        StringUtilsTest.assertNull((Object)StringUtils.classNameToVarName(""));
    }

    public void testCleanString() {
        String string = StringUtils.cleanString("\"");
        StringUtilsTest.assertTrue((boolean)string.equals("\\\""));
        string = StringUtils.cleanString("\\");
        StringUtilsTest.assertTrue((boolean)string.equals("\\\\"));
        string = StringUtils.cleanString("\n");
        StringUtilsTest.assertTrue((boolean)string.equals("\\n"));
        string = StringUtils.cleanString("\r");
        StringUtilsTest.assertTrue((boolean)string.equals("\\r"));
    }

    public void testGetChars() {
        String string = StringUtils.getChars(1, 'a');
        StringUtilsTest.assertTrue((boolean)string.equals(new String("a")));
        string = StringUtils.getChars(1, ' ');
        StringUtilsTest.assertTrue((boolean)string.equals(new String(" ")));
        string = StringUtils.getChars(10, ' ');
        StringUtilsTest.assertTrue((boolean)string.equals(new String("          ")));
        string = StringUtils.getChars(-1, 'a');
        StringUtilsTest.assertTrue((boolean)string.equals(new String("")));
    }

    public void testGetClassName() {
        String string = StringUtils.getClassName(new Byte("0").getClass());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("java.lang.Byte")));
        string = StringUtils.getClassName(new Byte[0][0][0].getClass());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("java.lang.Byte[][][]")));
        string = StringUtils.getClassName(new String("").getClass());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("java.lang.String")));
        string = StringUtils.getClassName(new String[0][0][0].getClass());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("java.lang.String[][][]")));
    }

    public void testGetCommaListFromVector() {
        Vector<Character> vector = new Vector<Character>();
        vector.add(new Character('a'));
        vector.add(new Character('b'));
        String string = StringUtils.getCommaListFromVector(vector);
        StringUtilsTest.assertTrue((boolean)string.equals(new String("a, b")));
        string = StringUtils.getCommaListFromVector(new Vector());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("")));
    }

    public void testGetContentAsReader() throws MalformedURLException, IOException {
        File file = File.createTempFile("Test", "txt");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("file name : Test.txt");
        printWriter.flush();
        Reader reader = StringUtils.getContentAsReader(file.toURL());
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringUtilsTest.assertTrue((boolean)bufferedReader.readLine().equals(new String("file name : Test.txt")));
    }

    public void testGetContentAsString() throws IOException {
        File file = File.createTempFile("Test", "txt");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("file name : Test.txt");
        printWriter.flush();
        String string = StringUtils.getContentAsString(file.toURL());
        StringUtilsTest.assertTrue((boolean)string.equals(new String("file name : Test.txt" + lineSeparator)));
    }

    public void testGetSafeString() {
        String string = StringUtils.getSafeString("test-string");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"test-string\"" + lineSeparator)));
        string = StringUtils.getSafeString("");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"\"" + lineSeparator)));
        string = StringUtils.getSafeString("\n");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"\"" + lineSeparator)));
        string = StringUtils.getSafeString("\r");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"\"" + lineSeparator)));
        string = StringUtils.getSafeString("\\n");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"\\\\n\"" + lineSeparator)));
        string = StringUtils.getSafeString("\\r");
        StringUtilsTest.assertTrue((boolean)string.equals(new String("\"\\\\r\"" + lineSeparator)));
    }

    public void testGetValidIdentifierName() {
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("identifier").equals(new String("identifier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("0identifier").equals(new String("_identifier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("i0dentifier").equals(new String("i0dentifier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("$identifier").equals(new String("$identifier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("identi$fier").equals(new String("identi$fier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName(" identifier").equals(new String("_identifier")));
        StringUtilsTest.assertTrue((boolean)StringUtils.getValidIdentifierName("identi fier").equals(new String("identi_fier")));
        StringUtilsTest.assertNull((Object)StringUtils.getValidIdentifierName(""));
        StringUtilsTest.assertNull((Object)StringUtils.getValidIdentifierName(null));
    }

    public void testIsValidIdentifierName() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidIdentifierName("identifier"));
        StringUtilsTest.assertTrue((!StringUtils.isValidIdentifierName("0identifier") ? 1 : 0) != 0);
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidIdentifierName("i0dentifier"));
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidIdentifierName("$identifier"));
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidIdentifierName("identi$fier"));
        StringUtilsTest.assertTrue((!StringUtils.isValidIdentifierName(" identifier") ? 1 : 0) != 0);
        StringUtilsTest.assertTrue((!StringUtils.isValidIdentifierName("identi fier") ? 1 : 0) != 0);
        StringUtilsTest.assertNull((Object)StringUtils.getValidIdentifierName(null));
        StringUtilsTest.assertNull((Object)StringUtils.getValidIdentifierName(""));
    }

    public void testIsValidPackageName() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidPackageName("org"));
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidPackageName("org.apache.bsf"));
        StringUtilsTest.assertTrue((!StringUtils.isValidPackageName("org.apache.bsf.") ? 1 : 0) != 0);
        StringUtilsTest.assertTrue((!StringUtils.isValidPackageName("org.apache.bsf..") ? 1 : 0) != 0);
        StringUtilsTest.assertTrue((boolean)StringUtils.isValidPackageName(""));
        StringUtilsTest.assertTrue((!StringUtils.isValidPackageName(null) ? 1 : 0) != 0);
    }
}

