/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

public class DebugLog {
    public static final int BSF_LOG_L0 = 0;
    public static final int BSF_LOG_L1 = 1;
    public static final int BSF_LOG_L2 = 2;
    public static final int BSF_LOG_L3 = 3;
    public static Hashtable logLevels;
    private static int loglevel;
    private static PrintStream debugStream;

    public static void stdoutPrint(Object object, int n) {
        DebugLog.streamPrint(object, System.out, n);
    }

    public static void stdoutPrintln(Object object, int n) {
        DebugLog.streamPrintln(object, System.out, n);
    }

    public static void stderrPrint(Object object, int n) {
        DebugLog.streamPrint(object, System.err, n);
    }

    public static void stderrPrintln(Object object, int n) {
        DebugLog.streamPrintln(object, System.err, n);
    }

    public static void debugPrint(Object object, int n) {
        DebugLog.streamPrint(object, debugStream, n);
    }

    public static void debugPrintln(Object object, int n) {
        DebugLog.streamPrintln(object, debugStream, n);
    }

    public static void setDebugStream(PrintStream printStream) {
        debugStream = printStream;
    }

    public static PrintStream getDebugStream() {
        return debugStream;
    }

    public static void setLogLevel(int n) {
        if (n != loglevel && n >= 0) {
            try {
                final int n2 = n;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        System.setProperty("org.apache.bsf.logLevel", String.valueOf(n2));
                        return null;
                    }
                });
                loglevel = n2;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                System.err.println("Unable to set loglevel: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static int getLogLevel() {
        return loglevel;
    }

    public static void streamPrint(Object object, OutputStream outputStream, int n) {
        if (loglevel >= n) {
            PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream, true);
            printStream.print(object);
        }
    }

    public static void streamPrintln(Object object, OutputStream outputStream, int n) {
        if (loglevel >= n) {
            PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream, true);
            printStream.println(object);
        }
    }

    static {
        loglevel = 0;
        debugStream = System.err;
        Integer n = Integer.getInteger("org.apache.bsf.logLevel", 0);
        DebugLog.setLogLevel(n);
        logLevels = new Hashtable();
        logLevels.put("BSF_LOG_L0", new Integer(0));
        logLevels.put("BSF_LOG_L1", new Integer(1));
        logLevels.put("BSF_LOG_L2", new Integer(2));
        logLevels.put("BSF_LOG_L3", new Integer(3));
    }
}

