/*
 * Decompiled with CFR 0.152.
 */
package org.oorexx.datergf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;

public class TimeRGF
implements Cloneable,
Comparable,
Serializable {
    public static String version = "92.20060101";
    public static char timeSeparator = (char)58;
    public static String[] am_pm_string = new String[]{"am", "pm"};
    public static boolean is24Hour = true;
    public static boolean showSecs = true;
    protected transient int hour;
    protected transient int minute;
    protected transient int second;
    protected transient int millis;
    protected transient int raw_millis;

    public TimeRGF() {
        this.raw_millis = 0;
        this.millis = 0;
        this.second = 0;
        this.minute = 0;
        this.hour = 0;
    }

    public TimeRGF(int n, int n2, int n3) {
        this.hour = TimeRGF.cI(n, 23);
        this.minute = TimeRGF.cI(n2, 59);
        this.second = TimeRGF.cI(n3, 59);
        this.millis = 0;
        this.raw_millis = n * 3600000 + n2 * 60000 + n3 * 1000 + this.millis;
    }

    public TimeRGF(int n, int n2, int n3, int n4) {
        this.hour = TimeRGF.cI(n, 23);
        this.minute = TimeRGF.cI(n2, 59);
        this.second = TimeRGF.cI(n3, 59);
        this.millis = TimeRGF.cI(n4, 999);
        this.raw_millis = n * 3600000 + n2 * 60000 + n3 * 1000 + n4;
    }

    public static TimeRGF valueOf(float f) {
        TimeRGF timeRGF = new TimeRGF();
        boolean bl = false;
        if (f < 0.0f) {
            bl = true;
            f = -f;
        }
        timeRGF.raw_millis = (int)(f * 86400.0f + 0.5f) % 86400;
        if (bl) {
            timeRGF.raw_millis = 86400 - timeRGF.raw_millis;
        }
        timeRGF.hour = timeRGF.raw_millis / 3600;
        int n = timeRGF.raw_millis % 3600;
        timeRGF.minute = n / 60;
        timeRGF.second = n % 60;
        timeRGF.millis = 0;
        timeRGF.raw_millis *= 1000;
        return timeRGF;
    }

    public static TimeRGF valueOf(int n, int n2) {
        boolean bl = false;
        TimeRGF timeRGF = new TimeRGF();
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        if (n == -1) {
            timeRGF.hour = n2 / 10000;
            int n3 = n2 % 10000;
            timeRGF.minute = n3 / 100;
            timeRGF.second = n3 % 100;
            timeRGF.millis = 0;
            timeRGF.raw_millis = (timeRGF.hour * 3600 + timeRGF.minute * 60 + timeRGF.second) * 1000;
            if (bl) {
                timeRGF.raw_millis = 86400000 - timeRGF.raw_millis;
                timeRGF.hour = timeRGF.raw_millis / 3600000;
                n3 = timeRGF.raw_millis % 3600000;
                timeRGF.minute = n3 / 60000;
                timeRGF.second = n3 % 60000 / 1000;
            }
        } else {
            if (n == -3) {
                n2 *= 1000;
            }
            if (n2 >= 86400000) {
                n2 %= 86400000;
            }
            if (bl) {
                n2 = 86400000 - n2;
            }
            timeRGF.raw_millis = n2;
            timeRGF.millis = n2 % 1000;
            int n4 = n2 / 1000;
            timeRGF.hour = n4 / 3600;
            timeRGF.minute = (n4 %= 3600) / 60;
            timeRGF.second = n4 % 60;
        }
        return timeRGF;
    }

    public static TimeRGF valueOf(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        for (n = 0; n < string.length() && string2.length() < 7; ++n) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                string3 = string3 + c;
                continue;
            }
            if (string3.length() == 1) {
                string2 = string2 + '0';
            }
            string2 = string2 + string3;
            string3 = "";
            if (c != timeSeparator) break;
        }
        if (string3.length() == 1) {
            string2 = string2 + '0';
        }
        if ((string2 = string2 + string3).length() < 3) {
            return null;
        }
        if (string2.length() < 5) {
            string2 = string2 + "00";
        }
        int n2 = Integer.parseInt(string2);
        int n3 = n2 / 10000;
        int n4 = (n2 %= 10000) / 100;
        int n5 = n2 % 100;
        if (!is24Hour) {
            int n6;
            boolean bl = false;
            while (string.charAt(n) == ' ' && n < string.length()) {
                ++n;
            }
            int n7 = string.length() - n + 1;
            for (n6 = 0; n6 < 2; ++n6) {
                String string4 = am_pm_string[n6];
                if (string4.length() > n7) continue;
                string3 = string.substring(n, n + string4.length());
                bl = true;
                for (n2 = 0; n2 < string4.length(); ++n2) {
                    if (string4.charAt(n2) == string3.charAt(n2)) continue;
                    bl = false;
                    break;
                }
                if (bl) break;
            }
            if (n6 == 0) {
                if (n3 == 12) {
                    n3 = 0;
                }
            } else if (n6 == 1 && n3 < 12) {
                n3 += 12;
            }
        }
        return new TimeRGF(n3, n4, n5);
    }

    public TimeRGF assign(TimeRGF timeRGF) {
        this.hour = timeRGF.hour;
        this.minute = timeRGF.minute;
        this.second = timeRGF.second;
        this.millis = timeRGF.millis;
        this.raw_millis = timeRGF.raw_millis;
        return this;
    }

    public int compareTo(Object object) {
        if (this.raw_millis < ((TimeRGF)object).raw_millis) {
            return -1;
        }
        if (this.raw_millis == ((TimeRGF)object).raw_millis) {
            return 0;
        }
        return 1;
    }

    public Object clone() {
        TimeRGF timeRGF = new TimeRGF();
        timeRGF.assign(this);
        return timeRGF;
    }

    public boolean equals(TimeRGF timeRGF) {
        return this.raw_millis == timeRGF.raw_millis;
    }

    public int get(int n) {
        switch (n) {
            case -100: {
                return this.hour;
            }
            case -101: {
                return this.minute;
            }
            case -102: {
                return this.second;
            }
            case -103: {
                return this.millis;
            }
            case -3: {
                return this.raw_millis / 1000;
            }
            case -110: 
            case -4: {
                return this.raw_millis;
            }
            case -1: {
                return this.hour * 10000 + this.minute * 100 + this.second;
            }
        }
        return -1;
    }

    public TimeRGF set(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n2 < 0;
        if (bl) {
            n2 = -n2;
        }
        switch (n) {
            case -100: {
                this.hour = TimeRGF.cI(n2, 23);
                break;
            }
            case -101: {
                this.minute = TimeRGF.cI(n2, 59);
                break;
            }
            case -102: {
                this.second = TimeRGF.cI(n2, 59);
                break;
            }
            case -103: {
                this.millis = TimeRGF.cI(n2, 999);
                break;
            }
            case -1: {
                this.hour = TimeRGF.cI(n2 / 10000, 23);
                int n3 = n2 % 10000;
                this.minute = TimeRGF.cI(n3 / 100, 59);
                this.second = TimeRGF.cI(n3 % 100, 59);
                this.millis = 0;
                break;
            }
            case -110: 
            case -4: {
                this.raw_millis = TimeRGF.cI(n2, 86399999);
            }
            case -3: {
                if (n == -3) {
                    this.raw_millis = TimeRGF.cI(n2, 86399) * 1000;
                }
                if (bl) {
                    this.raw_millis = 86400000 - this.raw_millis;
                }
                this.millis = this.raw_millis % 1000;
                int n4 = this.raw_millis / 1000;
                this.hour = n4 / 3600;
                this.minute = (n4 %= 3600) / 60;
                this.second = n4 % 60;
                return this;
            }
            default: {
                return this;
            }
        }
        this.raw_millis = this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.millis;
        return this;
    }

    public float subtract(TimeRGF timeRGF) {
        return (float)(this.raw_millis - this.millis - (timeRGF.raw_millis - timeRGF.millis)) / 8.64E7f;
    }

    public float toFloat() {
        return (float)(this.raw_millis - this.millis) / 8.64E7f;
    }

    public String toString() {
        if (!is24Hour) {
            int n = this.hour > 11 ? 1 : 0;
            return TimeRGF.ri(this.hour == 0 ? 12 : (this.hour > 12 ? this.hour - 12 : this.hour)) + timeSeparator + TimeRGF.ri(this.minute) + (showSecs ? timeSeparator + TimeRGF.ri(this.second) : "") + " " + am_pm_string[n];
        }
        return TimeRGF.ri(this.hour) + timeSeparator + TimeRGF.ri(this.minute) + (showSecs ? timeSeparator + TimeRGF.ri(this.second) : "");
    }

    private static String ri(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return "" + n;
    }

    private static int cI(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n > n2) {
            return n % (n2 + 1);
        }
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.raw_millis);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.set(-4, objectInputStream.readInt());
    }

    public TimeRGF update() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.hour = gregorianCalendar.get(11);
        this.minute = gregorianCalendar.get(12);
        this.second = gregorianCalendar.get(13);
        this.millis = gregorianCalendar.get(14);
        this.raw_millis = this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.millis;
        return this;
    }
}

