/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.util.BitSet;
import org.rexxla.bsf.engines.rexx.RexxAndJava;
import org.rexxla.bsf.engines.rexx.RexxCommandHandler;

public interface RexxRedirectingCommandHandler
extends RexxCommandHandler {
    public static final String version = "850.20220822";
    public static final int IS_REDIRECTION_REQUESTED = 0;
    public static final int IS_INPUT_REDIRECTED = 1;
    public static final int IS_OUTPUT_REDIRECTED = 2;
    public static final int IS_ERROR_REDIRECTED = 3;
    public static final int ARE_OUTPUT_AND_ERROR_SAME_TARGET = 4;

    @Override
    default public boolean isRedirectable() {
        return true;
    }

    default public boolean isRedirectionRequested(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4) {
            return false;
        }
        return ((BitSet)objectArray[5]).get(0);
    }

    default public boolean isInputRedirected(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4) {
            return false;
        }
        return ((BitSet)objectArray[5]).get(1);
    }

    default public boolean isOutputRedirected(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4) {
            return false;
        }
        return ((BitSet)objectArray[5]).get(2);
    }

    default public boolean isErrorRedirected(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4) {
            return false;
        }
        return ((BitSet)objectArray[5]).get(3);
    }

    default public boolean areOutputAndErrorSameTarget(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4) {
            return false;
        }
        return ((BitSet)objectArray[5]).get(4);
    }

    default public String readInput(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isInputRedirected(object)) {
            return null;
        }
        return ((RexxAndJava)objectArray[0]).jniRCH_Read(objectArray, 0);
    }

    default public byte[] readInputAsByteArray(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isInputRedirected(object)) {
            return null;
        }
        byte[] byArray = ((RexxAndJava)objectArray[0]).jniRCH_ReadAsByteArray(objectArray);
        return byArray;
    }

    default public String readInputBuffer(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isInputRedirected(object)) {
            return null;
        }
        return ((RexxAndJava)objectArray[0]).jniRCH_Read(objectArray, 1);
    }

    default public void writeOutput(Object object, String string) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isOutputRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 0, string);
    }

    default public void writeOutput(Object object, byte[] byArray) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isOutputRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 0, byArray);
    }

    default public void writeOutputBuffer(Object object, String string) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isOutputRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 1, string);
    }

    default public void writeError(Object object, String string) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isErrorRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 2, string);
    }

    default public void writeError(Object object, byte[] byArray) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isErrorRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 2, byArray);
    }

    default public void writeErrorBuffer(Object object, String string) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length <= 4 || !this.isErrorRedirected(object)) {
            return;
        }
        ((RexxAndJava)objectArray[0]).jniRCH_Write(objectArray, 3, string);
    }

    @Override
    default public String toString(Object object, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("environmentName=").append(string).append(',');
        stringBuffer.append("isRedirectable=").append(this.isRedirectable()).append(',');
        stringBuffer.append("isRedirectionRequested=").append(this.isRedirectionRequested(object)).append(',');
        stringBuffer.append("isInputRedirected=").append(this.isInputRedirected(object)).append(',');
        stringBuffer.append("isOutputRedirected=").append(this.isOutputRedirected(object)).append(',');
        stringBuffer.append("isErrorRedirected=").append(this.isErrorRedirected(object)).append(',');
        stringBuffer.append("areOutputAndErrorSameTarget=").append(this.areOutputAndErrorSameTarget(object));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

