/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

public final class Paragraph<PS, SEG, S> {
    private final List<SEG> segments;
    private final TwoLevelNavigator navigator;
    private final PS paragraphStyle;
    private final SegmentOps<SEG, S> segmentOps;
    private int length = -1;
    private String text = null;

    @SafeVarargs
    private static <T> List<T> list(T head, T ... tail) {
        if (tail.length == 0) {
            return Collections.singletonList(head);
        }
        ArrayList<T> list = new ArrayList<T>(1 + tail.length);
        list.add(head);
        Collections.addAll(list, tail);
        return list;
    }

    @SafeVarargs
    public Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, SEG text, SEG ... texts) {
        this(paragraphStyle, segmentOps, Paragraph.list(text, texts));
    }

    Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, List<SEG> segments) {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct a Paragraph with an empty list of segments");
        }
        this.segmentOps = segmentOps;
        this.segments = segments;
        this.paragraphStyle = paragraphStyle;
        this.navigator = new TwoLevelNavigator(segments::size, i -> segmentOps.length(segments.get(i)));
    }

    public List<SEG> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public PS getParagraphStyle() {
        return this.paragraphStyle;
    }

    public int length() {
        if (this.length == -1) {
            this.length = this.segments.stream().mapToInt(this.segmentOps::length).sum();
        }
        return this.length;
    }

    public char charAt(int index) {
        TwoDimensional.Position pos = this.navigator.offsetToPosition(index, TwoDimensional.Bias.Forward);
        return this.segmentOps.charAt(this.segments.get(pos.getMajor()), pos.getMinor());
    }

    public String substring(int from, int to) {
        return this.getText().substring(from, Math.min(to, this.length()));
    }

    public String substring(int from) {
        return this.getText().substring(from);
    }

    public Paragraph<PS, SEG, S> concat(Paragraph<PS, SEG, S> p) {
        SEG right;
        if (p.length() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return p;
        }
        SEG left = this.segments.get(this.segments.size() - 1);
        Optional<SEG> joined = this.segmentOps.join(left, right = p.segments.get(0));
        if (joined.isPresent()) {
            SEG segment = joined.get();
            ArrayList<SEG> segs = new ArrayList<SEG>(this.segments.size() + p.segments.size() - 1);
            segs.addAll(this.segments.subList(0, this.segments.size() - 1));
            segs.add(segment);
            segs.addAll(p.segments.subList(1, p.segments.size()));
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs);
        }
        ArrayList<SEG> segs = new ArrayList<SEG>(this.segments.size() + p.segments.size());
        segs.addAll(this.segments);
        segs.addAll(p.segments);
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs);
    }

    Paragraph<PS, SEG, S> concatR(Paragraph<PS, SEG, S> that) {
        return this.length() == 0 && that.length() == 0 ? that : this.concat(that);
    }

    public Paragraph<PS, SEG, S> subSequence(int start, int end) {
        return this.trim(end).subSequence(start);
    }

    public Paragraph<PS, SEG, S> trim(int length) {
        if (length >= this.length()) {
            return this;
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(length, TwoDimensional.Bias.Backward);
        int segIdx = pos.getMajor();
        ArrayList<SEG> segs = new ArrayList<SEG>(segIdx + 1);
        segs.addAll(this.segments.subList(0, segIdx));
        segs.add(this.segmentOps.subSequence(this.segments.get(segIdx), 0, pos.getMinor()));
        if (segs.isEmpty()) {
            segs.add(this.segmentOps.createEmpty());
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs);
    }

    public Paragraph<PS, SEG, S> subSequence(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("start must not be negative (was: " + start + ")");
        }
        if (start == 0) {
            return this;
        }
        if (start <= this.length()) {
            TwoDimensional.Position pos = this.navigator.offsetToPosition(start, TwoDimensional.Bias.Forward);
            int segIdx = pos.getMajor();
            ArrayList<SEG> segs = new ArrayList<SEG>(this.segments.size() - segIdx);
            segs.add(this.segmentOps.subSequence(this.segments.get(segIdx), pos.getMinor()));
            segs.addAll(this.segments.subList(segIdx + 1, this.segments.size()));
            if (segs.isEmpty()) {
                segs.add(this.segmentOps.createEmpty());
            }
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs);
        }
        throw new IndexOutOfBoundsException(start + " not in [0, " + this.length() + "]");
    }

    public Paragraph<PS, SEG, S> delete(int start, int end) {
        return this.trim(start).concat(this.subSequence(end));
    }

    public Paragraph<PS, SEG, S> restyle(S style) {
        ArrayList<SEG> segs = new ArrayList<SEG>();
        Iterator<SEG> it = this.segments.iterator();
        segs.add(this.segmentOps.setStyle(it.next(), style));
        while (it.hasNext()) {
            SEG cur;
            Object prev = segs.get(segs.size() - 1);
            Optional<SEG> joined = this.segmentOps.join(prev, cur = this.segmentOps.setStyle(it.next(), style));
            if (joined.isPresent()) {
                segs.set(segs.size() - 1, joined.get());
                continue;
            }
            segs.add(cur);
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs);
    }

    public Paragraph<PS, SEG, S> restyle(int from, int to, S style) {
        if (from >= this.length()) {
            return this;
        }
        to = Math.min(to, this.length());
        Paragraph<PS, SEG, S> left = this.subSequence(0, from);
        Paragraph<PS, SEG, S> middle = this.subSequence(from, to).restyle(style);
        Paragraph<PS, SEG, S> right = this.subSequence(to);
        return left.concat(middle).concat(right);
    }

    public Paragraph<PS, SEG, S> restyle(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        if (styleSpans.equals(this.getStyleSpans(from, from + len))) {
            return this;
        }
        Paragraph<PS, SEG, S> left = this.trim(from);
        Paragraph<PS, SEG, S> right = this.subSequence(from + len);
        Paragraph<PS, SEG, S> middle = this.subSequence(from, from + len);
        ArrayList<SEG> middleSegs = new ArrayList<SEG>(styleSpans.getSpanCount());
        int offset = 0;
        for (StyleSpan<S> span : styleSpans) {
            int end = offset + span.getLength();
            Paragraph<PS, SEG, S> text = middle.subSequence(offset, end);
            middleSegs.addAll(text.restyle(span.getStyle()).segments);
            offset = end;
        }
        Paragraph<PS, SEG, S> newMiddle = new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, middleSegs);
        return left.concat(newMiddle).concat(right);
    }

    public Paragraph<PS, SEG, S> setParagraphStyle(PS paragraphStyle) {
        return new Paragraph<PS, SEG, S>(paragraphStyle, this.segmentOps, this.segments);
    }

    public S getStyleOfChar(int charIdx) {
        if (charIdx < 0) {
            return this.segmentOps.getStyle(this.segments.get(0));
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward);
        return this.segmentOps.getStyle(this.segments.get(pos.getMajor()));
    }

    public S getStyleAtPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Paragraph position cannot be negative (" + position + ")");
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Backward);
        return this.segmentOps.getStyle(this.segments.get(pos.getMajor()));
    }

    public IndexRange getStyleRangeAtPosition(int position) {
        TwoDimensional.Position pos = this.navigator.offsetToPosition(position, TwoDimensional.Bias.Backward);
        int start = position - pos.getMinor();
        int end = start + this.segmentOps.length(this.segments.get(pos.getMajor()));
        return new IndexRange(start, end);
    }

    public StyleSpans<S> getStyleSpans() {
        StyleSpansBuilder<S> builder = new StyleSpansBuilder<S>(this.segments.size());
        for (SEG seg : this.segments) {
            builder.add(this.segmentOps.getStyle(seg), this.segmentOps.length(seg));
        }
        return builder.create();
    }

    public StyleSpans<S> getStyleSpans(int from, int to) {
        TwoDimensional.Position start = this.navigator.offsetToPosition(from, TwoDimensional.Bias.Forward);
        TwoDimensional.Position end = to == from ? start : start.offsetBy(to - from, TwoDimensional.Bias.Backward);
        int startSegIdx = start.getMajor();
        int endSegIdx = end.getMajor();
        int n = endSegIdx - startSegIdx + 1;
        StyleSpansBuilder<S> builder = new StyleSpansBuilder<S>(n);
        if (startSegIdx == endSegIdx) {
            SEG seg = this.segments.get(startSegIdx);
            builder.add(this.segmentOps.getStyle(seg), to - from);
        } else {
            SEG startSeg = this.segments.get(startSegIdx);
            builder.add(this.segmentOps.getStyle(startSeg), this.segmentOps.length(startSeg) - start.getMinor());
            for (int i = startSegIdx + 1; i < endSegIdx; ++i) {
                SEG seg = this.segments.get(i);
                builder.add(this.segmentOps.getStyle(seg), this.segmentOps.length(seg));
            }
            SEG endSeg = this.segments.get(endSegIdx);
            builder.add(this.segmentOps.getStyle(endSeg), end.getMinor());
        }
        return builder.create();
    }

    public String getText() {
        if (this.text == null) {
            StringBuilder sb = new StringBuilder(this.length());
            for (SEG seg : this.segments) {
                sb.append(this.segmentOps.getText(seg));
            }
            this.text = sb.toString();
        }
        return this.text;
    }

    public String toString() {
        return "Par[" + this.paragraphStyle + "; " + this.segments.stream().map(Object::toString).reduce((s1, s2) -> s1 + "," + s2).orElse("") + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof Paragraph) {
            Paragraph that = (Paragraph)other;
            return Objects.equals(this.paragraphStyle, that.paragraphStyle) && Objects.equals(this.segments, that.segments);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.paragraphStyle, this.segments);
    }
}

