/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;
import java.util.Optional;

public abstract class TextChange<S, Self extends TextChange<S, Self>> {
    private ChangeType type;
    protected final int position;
    protected final S removed;
    protected final S inserted;

    public final ChangeType getType() {
        return this.type;
    }

    public TextChange(int position, S removed, S inserted) {
        this.position = position;
        this.removed = removed;
        this.inserted = inserted;
        if (this.insertedLength() == 0) {
            if (this.removedLength() == 0) {
                throw new IllegalStateException("Cannot get the type of a change that neither inserts nor deletes anything.");
            }
            this.type = ChangeType.DELETION;
        } else {
            this.type = this.removedLength() == 0 ? ChangeType.INSERTION : ChangeType.REPLACEMENT;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public S getRemoved() {
        return this.removed;
    }

    public S getInserted() {
        return this.inserted;
    }

    public Self invert() {
        return this.create(this.position, this.inserted, this.removed);
    }

    public int getRemovalEnd() {
        return this.position + this.removedLength();
    }

    public int getInsertionEnd() {
        return this.position + this.insertedLength();
    }

    protected abstract int removedLength();

    protected abstract int insertedLength();

    protected abstract S concat(S var1, S var2);

    protected abstract S sub(S var1, int var2, int var3);

    protected abstract Self create(int var1, S var2, S var3);

    public Optional<Self> mergeWith(Self latter) {
        if (this.getType() != ChangeType.REPLACEMENT && this.getType() == ((TextChange)latter).getType() && this.getInsertionEnd() == ((TextChange)latter).position) {
            S removedText = this.concat(this.removed, ((TextChange)latter).removed);
            S addedText = this.concat(this.inserted, ((TextChange)latter).inserted);
            return Optional.of(this.create(this.position, removedText, addedText));
        }
        return Optional.empty();
    }

    public boolean equals(Object other) {
        if (other instanceof TextChange) {
            TextChange that = (TextChange)other;
            return Objects.equals(this.position, that.position) && Objects.equals(this.removed, that.removed) && Objects.equals(this.inserted, that.inserted);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.position, this.removed, this.inserted);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{\n\tposition: " + this.position + "\n\ttype: " + (Object)((Object)this.type) + "\n\tremoved: " + this.removed + "\n\tinserted: " + this.inserted + "\n}";
    }

    public static enum ChangeType {
        INSERTION,
        DELETION,
        REPLACEMENT;

    }
}

