/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo.impl;

import java.util.ArrayList;
import org.fxmisc.undo.impl.ChangeQueue;
import org.fxmisc.undo.impl.RevisionedChange;

public class UnlimitedChangeQueue<C>
implements ChangeQueue<C> {
    private final ArrayList<RevisionedChange<C>> changes = new ArrayList();
    private int currentPosition = 0;
    private long revision;
    private long zeroPositionRevision = this.revision = 0L;
    private int forgottenCount = 0;

    @Override
    public final boolean hasNext() {
        return this.currentPosition < this.changes.size();
    }

    @Override
    public final boolean hasPrev() {
        return this.currentPosition > 0;
    }

    @Override
    public final C next() {
        return this.changes.get(this.currentPosition++).getChange();
    }

    @Override
    public final C prev() {
        return this.changes.get(--this.currentPosition).getChange();
    }

    @Override
    public void forgetHistory() {
        if (this.currentPosition > 0) {
            this.zeroPositionRevision = this.revisionForPosition(this.currentPosition);
            int newSize = this.changes.size() - this.currentPosition;
            for (int i = 0; i < newSize; ++i) {
                this.changes.set(i, this.changes.get(this.currentPosition + i));
            }
            this.changes.subList(newSize, this.changes.size()).clear();
            this.forgottenCount += this.currentPosition;
            this.currentPosition = 0;
        }
    }

    @Override
    @SafeVarargs
    public final void push(C ... changes) {
        this.changes.subList(this.currentPosition, this.changes.size()).clear();
        for (C c : changes) {
            RevisionedChange<C> revC = new RevisionedChange<C>(c, ++this.revision);
            this.changes.add(revC);
        }
        this.currentPosition += changes.length;
    }

    @Override
    public ChangeQueue.QueuePosition getCurrentPosition() {
        return new QueuePositionImpl(this.forgottenCount + this.currentPosition, this.revisionForPosition(this.currentPosition));
    }

    private long revisionForPosition(int position) {
        return position == 0 ? this.zeroPositionRevision : this.changes.get(position - 1).getRevision();
    }

    private class QueuePositionImpl
    implements ChangeQueue.QueuePosition {
        private final int allTimePos;
        private final long rev;

        QueuePositionImpl(int allTimePos, long rev) {
            this.allTimePos = allTimePos;
            this.rev = rev;
        }

        @Override
        public boolean isValid() {
            int pos = this.allTimePos - UnlimitedChangeQueue.this.forgottenCount;
            if (0 <= pos && pos <= UnlimitedChangeQueue.this.changes.size()) {
                return this.rev == UnlimitedChangeQueue.this.revisionForPosition(pos);
            }
            return false;
        }

        public boolean equals(Object other) {
            if (other instanceof QueuePositionImpl) {
                QueuePositionImpl otherPos = (QueuePositionImpl)other;
                return this.getQueue() == otherPos.getQueue() && this.rev == otherPos.rev;
            }
            return false;
        }

        private UnlimitedChangeQueue<C> getQueue() {
            return UnlimitedChangeQueue.this;
        }
    }
}

