#!/usr/bin/env rexx
/* ooRexx script to replace elevate32.exe, -64.exe programs from the
    Elevation Toolkit (Elevate and IsElevated)
    Copyright  2010 by Bill Stewart

    Accepts the (optional) -w(ait) switch only
    */
    parse arg theArgs
    if theArgs = "" then do
        say "Usage: specify the command line to be run as Administrator"
        say "       as the arguments to this script.  An optional -w may"
        say "       be specified prior to the command line data to cause"
        say "       the script to wait for the elevated prompt to end"
        say "       before terminating."
        exit
    end
    if theArgs~word(1)~left(2)~upper = "-W" then do
        wait = .true
        theArgs = theArgs~subword(2)
    end
    else
        wait = .false

    cmdArgs = "/c cd /d" directory() "&&" theArgs
    if wait then do
        call lineout "cmd.running" -- create zero-length file
        cmdArgs ||= " && del cmd.running"
    end
/*  -- check for override to not use elevated prompt
    noUAC = (value("rexx_noUAC", , "ENVIRONMENT") = 1)
    verb = "runas open"~word(1 + noUAC)
*/  verb = "runas"
    ShellObj = .OLEObject~New("Shell.Application")
    ShellObj~ShellExecute("cmd.exe", cmdArgs, , verb)
    do 50
        call sysSleep .1
        if \SysFileExists("cmd.running") then
            leave
    end
    say "Done!"
    return