#!./bin/rexx
/*
	note: the hashbang above will use the local rexx executable by default, hence doing a "chmod 755 manageLinks.rex"
              will allow to run it from "/Applications/oorexx5" issuing "./manageLinks.rex", if it is located in "/Applications/oorexx5"


    	name:		manageLinks.rex
	purpose:	create or remove symbolic links in/from /usr/local/bin, /usr/local/lib, /usr/local/include 
	usage:		manageLinks.rex [-h | -l[ink] | -u[nlink]]
	 	        -h	... help (show usage), default if no flag supplied
			-l	... link: create symbolic links in /usr/local/{bin|lib|include}
			-u	... unlink: remove symbolic links from /usr/local/{bin|lib|include}
	author:		Rony G. Flatscher
	date:		2024-01-08
	license:	CPL v1.0, AL 2.0
*/

parse arg a .
if a='' | a~upper='-H' then
do
   say .resources~usage
   exit
end

flag=a~left(2)~upper
if wordpos(flag,'-L -U')=0 then
do
   say 'unknown argument ['a']'
   say .resources~usage
   exit -1 
end

tgtDir = "/usr/local"			-- target directory
dirs   = ('bin', 'lib', 'include')	-- subdirs to process
lnCmd  = 'ln -sfv' 			-- force symbolic link
rmCmd  = 'rm -fv' 			-- force remove
toDevNull = '> /dev/null 2>&1'		-- redirect stdout and stderr 

do tmpDir over dirs			-- iterate over all directories
   tmpTgtDir = tgtDir"/"tmpDir		
   call sysFileTree tmpDir'/*', 'files.', 'FO'
   say tmpDir":" files.0 "file(s) to process ..."	
   do i=1 to files.0			-- iterate over all files
      fname=filespec('name',files.i)	-- get filename only
      if flag='-L' then cmd="sudo" lnCmd files.i tmpTgtDir"/"fname	-- install command
                   else cmd="sudo" rmCmd tmpTgtDir"/"fname		-- uninstall command
      say cmd		-- show command to user
      cmd toDevNull	-- run command do not show any output to stdout or stderr, return code saved to variable RC by Rexx
      if rc<>0 then say "09"x "->" cmd "- failed, RC="rc
   end
end

::resource usage
name:		manageLinks.rex
purpose:	create or remove symbolic links in/from /usr/local/bin, /usr/local/lib, /usr/local/include 
usage:		sudo ./manageLinks.rex [-h | -l[ink] | -u[nlink]]
                flags:
		-h	... help (show usage), default if no flag supplied
		-l	... link: create symbolic links in /usr/local/{bin|lib|include}
		-u	... unlink: remove symbolic links from /usr/local/{bin|lib|include}
::END
