
import java.lang.reflect.*;

import java.text.DateFormatSymbols;
import java.util.Locale;

import java.util.Arrays;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

// import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.CategoryAxis;

public class Test
{

    public static void main (String args[]) {

        Class<?> aClz=Arrays.class;
        dumpClz(aClz);
        System.out.println("\n===================================================== \n");


        String [] months = DateFormatSymbols.getInstance(Locale.ENGLISH).getMonths();

        ObservableList ol=FXCollections.observableArrayList();
        ol.addAll( Arrays.asList( months) );

        Class<?> olClz=ol.getClass();
        dumpClz(olClz);
        System.out.println("\n===================================================== \n");

        Class<?> caClz =CategoryAxis.class;
        dumpClz(caClz);
        System.out.println("\n===================================================== \n");

        System.out.println("ol           ="+ol
                        +"\nol.getClass()="+ol.getClass()
                        +"\nol.toArray() ="+Arrays.deepToString(ol.toArray())
                        );


/*
        String clzName="com.sun.javafx.collections.ObservableListWrapper";
        Class<?> clz;

        try {

            clz=Test.class.getClassLoader().loadClass(clzName);
            dumpClz(clz);
        }
        catch (Throwable t)
        {
            System.err.println("Oops! Throwable=["+t+"]");
            t.printStackTrace();
        }
*/

    }

    public static void dumpClz (Class<?> clz) {
        try {
            while (clz!=null)
            {
                printMethods("", "\t", clz);
                System.out.println();

                Class<?> [] ifClz=clz.getInterfaces();
                for (Class<?> tif : ifClz)
                {
                    printMethods("\t-->\t", "\t\t\t", tif);
                    System.out.println();

                    Class <?> tifSC=tif.getSuperclass();
                    while (tifSC!=null)
                    {
                        printMethods("\t-->\t\tsuperInterface", "\t\t\t\t", tifSC);
                        System.out.println();

                        tifSC=tifSC.getSuperclass();
                    }
                }
                System.out.println();
                clz=clz.getSuperclass();
            }

        }
        catch (Throwable t)
        {
            System.err.println("Oops! Throwable=["+t+"]");
            t.printStackTrace();
        }
    }

    static void printMethods(String title, String leadin, Class<?> clz)
    {
        System.out.println(title+clz+" | .toString()="+clz.toString());
        Method methods[]=clz.getDeclaredMethods();
        for (Method m : methods)
        {
            System.out.println(leadin+left(m.getName())+": "+m);
            // System.out.println("\t"+m.getName()+":\t"+m.getReturnType());
        }

    }

    static String left(String str)
    {
        String bgd="............................................................";

        int strLength=str.length(),
            maxLength=30,
            end =maxLength-strLength;
        if (end>0 && end<bgd.length())
        {
            return str+bgd.substring(0,end);
        }
        return str;

    }


}
