// import static bla.bla.bla.RexxCleanupRef.RefKind.* ;

public class TestObject extends Object {
        static boolean bDebug=true;
        static int counter=0;
        int num;


        public static void main (String args[]) throws InterruptedException
        {
            java.util.ArrayList<TestObject> al = new java.util.ArrayList<TestObject>();
            java.util.ArrayList<RexxCleanupRef> references = new java.util.ArrayList<RexxCleanupRef>();

            for (int i=0; i<10; i++)
            {
                TestObject jobj=new TestObject();
                al.add(jobj);
                switch (i % 5)
                {
                    case 0: references.add(new RexxCleanupRef(jobj, RexxCleanupRef.RefKind.REXX_ENGINE, "Rexx_Engine_"+i));
                            break;
                    case 1: references.add(new RexxCleanupRef(jobj, RexxCleanupRef.RefKind.REXX_PROXY, "Rexx_Proxy_"+i));
                        break;
                    default:
                            references.add(new RexxCleanupRef(jobj, RexxCleanupRef.RefKind.TEST, "some_string_"+i));
                }
            }

            for (RexxCleanupRef ref : references)
            {
                System.out.println("ref=["+ref+"] isEnqueued: "+ref.isEnqueued());
            }
            System.out.println(" nullifying 'al', doing a gc()... ");
            al=null;
            RexxCleanupRef.clean();
            System.gc();
            RexxCleanupRef.clean();
            System.out.println(" ... followed by a runFinalization()... ");
            System.runFinalization();
            System.out.println(" ... runFinalization() done!... ");
            RexxCleanupRef.clean();
            for (RexxCleanupRef ref : references)
            {
                System.out.println("ref=["+ref+"] isEnqueued: "+ref.isEnqueued());
            }

            // System.out.println(" doing a runFinalization ... ");
            // System.runFinalization();
            for (RexxCleanupRef ref : references)
            {
                System.out.println("ref=["+ref+"] isEnqueued: "+ref.isEnqueued());
            }

            if (bDebug==true) System.err.println("main(): sleeping 2000 ms");
            Thread.sleep(2000);
            if (bDebug==true) System.err.println("main(): sleep over, invoking clean()");
            System.gc();
            // System.runFinalization();
            RexxCleanupRef.clean();
            if (bDebug==true) System.err.println("main(): sleeping 1000 ms");
            Thread.sleep(1000);
        }



        TestObject ()
        {
            super();
            num=counter++;
        }

        @Override
        public void finalize()
        {
            System.err.println("*** "+this+": *** finalize() ***");
        }

        public String toString()
        {
            return "/ TestObject # "+num+" \\";

        }
    }
