#!/usr/bin/env rexx
-- test times to invoke a native function


calls=100000

startDT=.dateTime~new
say "started:" startDT
say
call dump2 .routines, ".Routines"
say

say "--- plain external call, call via package .routines " ~left(140, "-")
baseSecs=plainCall_BsfTestPing(calls,.nil)   -- get base seconds (relativity=100%)
call plainCall_ZBsfTestPing calls, baseSecs

say "--- external call, using the routine object from package .routines " ~left(140, "-")
call callAsRoutine1 calls, baseSecs
call callAsRoutine2 calls, baseSecs
call callAsRoutine3 calls, baseSecs
say "-"~copies(140)
say

say "--- external call, fetching and invoking routine via the object "~left(140,"-")
p=.pst~new
p~doTheWork_01(calls, baseSecs)
p~doTheWork_02(calls, baseSecs)
say

say "--- external call, fetching and invoking routine via a subclass object "~left(140,"-")
s=.pstSubclass~new
s~doTheWork(calls, baseSecs)
say

say "--- roundtrip calls to Java "~left(140,"-")
call callBSF_External_roundTripToJava calls, baseSecs
call callBSF_Routine_roundTripToJava  calls, baseSecs
say

say "--- Java sends 'HI' to Rexx object " ~left(140, "-")
call callBSF_Routine_sendback_Rexx_Message calls, baseSecs
say

say "--- native code calls Java i-times " ~left(140, "-")
call cpp_calls_TestPingOnJava calls, baseSecs
say

say "--- Java calls native code i-times " ~left(140, "-")
call callBSF_Routine_callback_JNI calls, baseSecs
say

endDT=.dateTime~new
say "--- done." ""~left(140,"-")
say
say "started:" startDT "ended:" endDT "duration (ended-started):" (endDT-startDT)


exit

say "--- via the object"~left(140,"-")
p=.pst~new
p~doTheWork(calls)
p~doTheWork2(calls)

say "--- via the class "~left(140,"-")

p~doTheWorkViaClass(calls)
s=.pstSub~new
s~doTheWorkViaSclass(calls)


say "-"~copies(140)
call testResolution calls

say "-"~copies(140)
call callBSF_routine    calls
call callBSF_external   calls

say "-"~copies(140)
call callBSF_routine_callback_JNI    calls
call callBSF_external_callback_JNI   calls

say "-"~copies(140)
call callBSF_routine_sendback_Rexx_Message calls
call callBSF_external_sendback_Rexx_Message calls

say "-"~copies(140)
call plainCall_further2Java  calls
call zCall_further2Java          calls

say "-"~copies(140)
call callAsRoutine_further2Java  calls
call callAsRoutine2_further2Java calls



::requires bsf.cls
::requires "rgf_util2.rex"





   -- plain call to external Rexx function, no arguments
::routine plainCall_BsfTestPing
   use arg i, baseSeconds

   say ("/// --->"  i "times: 'call BsfTestPing': normal call to external routine" "<--- (REFERENCE/BASE) <--- \\\")~left(140,".")

   startDT=.dateTime~new
   do i
     call BsfTestPing
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded

   say f("plainCall_BsfTestPing():") "'call BsfTestPing' directly   " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0))) "calls/second" "| relative performance:" f_create_idx(diff,diff) " <-- REFERENCE/BASE"
   say
   return diff    -- return time it took


::routine zBsfTestPing external "LIBRARY BSF4ooRexx BsfTestPing"

   -- plain call to package routine 'zCall'
::routine plainCall_ZBsfTestPing
   use arg i, baseSeconds
   say ("///--->" i "times: 'call zBsfTestPing': call to routine stored in package's .routines" "<--- \\\")~left(140,".")
   startDT=.dateTime~new
   do i
     call zBsfTestPing
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("plainCall_ZBsfTestPing():")     "'call zBsfTestPing' directly  " pp(i) "times lasted:" pp(diff)   "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say



::routine callAsRoutine1
   use arg i, baseSeconds
   say (f("///--->" i "times: callAsRoutine1():") ".routines~zBsfTestPing:" pp2(.routines~zBsfTestPing) "<--- \\\")~left(140,".")
   startDT=.dateTime~new
   do i
     .routines~zBsfTestPing~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("callAsRoutine1():") ".routines~zBsfTestPing~call   " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say



::routine callAsRoutine2
   use arg i, baseSeconds
   routine=.routines~zBsfTestPing
   ref2routines=.routines
   say (f("///--->" i "times: callAsRoutine2():") "ref2routines~zBsfTestPing:" pp2(routine) "<--- \\\")~left(140,".")
   startDT=.dateTime~new
   do i
     ref2routines~zBsfTestPing~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("callAsRoutine2():") "ref2routines~zBsfTestPing~call" pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


::routine callAsRoutine3
   use arg i, baseSeconds
   routine=.routines~zBsfTestPing
   say (f("///--->" i "times: callAsRoutine3():") "routine=.routines~zBsfTestPing:" pp2(routine) "<--- \\\")~left(140,".")
   startDT=.dateTime~new
   do i
     routine~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("callAsRoutine3():") "routine~call                  " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


-------------------------------------------------------------------------------------------------------------------------

::routine cpp_calls_TestPingOnJava
   use arg i, baseSeconds

   hint=f("cpp_calls_TestPingOnJava():")
   say ("/// --->" hint "'call zBsfTestPing', "i"': BsfTestPing()'s C++ code calls 'javaTestPing'" i "times" "<--- \\\")~left(140,".")
   startDT=.dateTime~new
   call zBsfTestPing i
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "'call zBsfTestPing, i         " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


-------------------------------------------------------------------------------------------------------------------------

::routine callBSF_External_roundTripToJava
   use arg i, baseSeconds
   hint=f("callBSF_External_roundTripToJava:")
   say  ("/// --->" i "times:" hint "call BSF 'testPing' (roundtrip from Rexx to Java) <--- \\\")~left(140,".")
   startDT=.dateTime~new
   do i
     call bsf "testPing"      -- round trip to Java
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "call bsf 'testPing'           " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


::routine callBSF_Routine_roundTripToJava
   use arg i, baseSeconds
   hint=f("callBSF_Routine_roundTripToJava:")
   say  ("/// --->" i "times:" hint "rBsf~call('testPing') (roundtrip from Rexx to Java) <--- \\\")~left(140,".")
   rBSF=.routines~xBSF     -- fetch BSF routine object
   startDT=.dateTime~new
   do i
     rBsf~call('testPing')       -- round trip to Java
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "rBsf~call('testPing')         " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


------------------------------------------- call to Java which calls back to native and even ooRexx


::routine xBSF                   EXTERNAL "LIBRARY BSF4ooRexx BSF                 "


::routine callBSF_Routine_callback_JNI
   use arg i, baseSeconds
   hint=f("callBSF_Routine_callback_JNI():")
   say  ("/// --->" i "times:" hint "rBsf~call('testPing',"i") (Java calling C++ function via JNI i times) <--- \\\")~left(140,".")

   rBSF=.routines~xBSF     -- fetch BSF routine object
   startDT=.dateTime~new
   rBsf~call('testPing', i)      -- let Java call i-times jniTestPing via JNI
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000100)  -- make sure we have at least 1/1000 second recorded
   say hint                   "rBsf~call('testPing',i)       " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say

-------------------------------------------------------------------------------------------------------------------------


::routine callBSF_Routine_sendback_Rexx_Message
   use arg i, baseSeconds
   hint=f("callBSF_Routine_sendback_Rexx_Message():")

   say  ("/// --->" hint "rBsf~call('testPing',"i", .test~new, 'HI') (Java sends message 'HI'" i "times to Rexx object) <--- \\\")~left(140,".")
   rBSF=.routines~xBSF     -- fetch BSF routine object

   startDT=.dateTime~new
   rBsf~call('testPing', i, .test~new, "HI")    -- Java sends 'HI' i-times to supplied Rexx object
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "rBsf~call('testPing',i,o,'HI')" pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


-------------------------------------------------------------------------------------------------------------------------


::routine testResolution
   parse arg i
   say
   say "testing resolving from .routines:"

   startDT=.dateTime~new
   do i
     .routines~zBsfTestPing
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("testResoultion():") ".routine~zBsfTestPing         " pp(i) "times lasted:" pp(diff) "or" pp(fmt(i/diff~totalSeconds)) "calls/second"
   say "--"

   say "testing resolving from .pst~myRoutine:"
   startDT=.dateTime~new
   do i
       .pst~myRoutine
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say f("testResoultion():") ".pst~myRoutine                " pp(i) "times lasted:" pp(diff) "or" pp(fmt(i/diff~totalSeconds)) "calls/second"



----------------------------------------------------------------------------------------------


::routine fmt  -- format number to nine digits and no fraction
  numeric digits 20
  use arg value, width=21

  parse var value val '.' fract
  val=val~strip
-- say "value="pp(value)":" "val="pp(val) "<- fract -->" pp(fract)

  if val~length>3 then     -- insert commas
  do
      newVal=""
      tmpVal=val~reverse
      do until tmpVal=""
         parse var tmpVal chunk +3 tmpVal
         if newVal<>"" then newVal =  newVal","chunk
                       else newVal=chunk~reverse
      end
      if fract="" then return newVal~reverse~right(width)
                  else return newVal~reverse~right(width)"."fract
  end
  if fract="" then return val~right(width)
              else return val~right(width)"."fract

::routine f    -- make sure hint is always 34 chars wide
  return arg(1)~left(34)


::routine f_create_idx  -- create and return relative performance indications
  use arg baseSeconds, elapsedTime
  numeric digits 20
  rel=baseSeconds~totalMicroseconds/elapsedTime~totalMicroseconds
  return fmt(format(rel*100,9,2)) "%" "->" fmt(format(rel, ,1)) "times"


-- ===========================================================================================

::class test      -- this class will be used from Java
::method hi       -- this method will be invoked from Java


-- ===========================================================================================

::class "pst"                    -- this class is used to test impact of access via an object

::method init class              -- saves routine object for "zBsfTestPing" in class attribute
  expose myRoutine
  myRoutine=.routines~zBsfTestPing

::attribute myRoutine class      -- used to save the routine object

::method init                    -- instance saves a reference to routine object in instance attribute
  expose myR                     -- attribute to refer to routine object
  myr=self~class~myRoutine

::method doTheWork_01
   use arg i, baseSeconds
   hint=f(pp(self)".doTheWork_01:")
   say ("///--->" i "times:" hint "self~class~myRoutine~call <---\\\")~left(140,".")
   startDT=.dateTime~new
   do i
     self~class~myRoutine~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "self~class~myRoutine~call     " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say

::method doTheWork_02
   expose myR
   use arg i, baseSeconds
   hint=f(pp(self)".doTheWork_02:")
   say ("///--->" i "times:" hint "myR~call <---\\\")~left(140,".")
   startDT=.dateTime~new
   do i
      myR~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "myR~call                      " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say


-- ===========================================================================================

::class "pstSubclass" subclass pst    -- this class is used to test impact of access via subclass
::method doTheWork
   use arg i, baseSeconds
   hint=f(pp(self)".doTheWork:")
   say ("///--->" i "times:" hint "self~class~myRoutine~call <---\\\")~left(140,".")

   startDT=.dateTime~new
   do i
     self~class~myRoutine~call
   end
   endDT=.dateTime~new
   diff=endDT-startDT
   if diff~totalSeconds=0 then diff=diff~addSeconds(0.000001)  -- make sure we have at least 1/1000 second recorded
   say hint                   "self~class~myRoutine~call     " pp(i) "times lasted:" pp(diff) "or" pp(fmt(format(i/diff~totalSeconds, ,0)))  "calls/second" "| relative performance:" f_create_idx(baseSeconds,diff)
   say
