// rgf, 2009-08-26, 2009-09-05
// define a class that uses an ITest object, which now can also be a RexxProxy
// that declares to implement the "ITest" interface, i.e. all its methods;
// the RexxProxy implementation may take advantage of the ooRexx UNKNOWN mechanism

package rgf.D_abstractClasses;

import org.rexxla.bsf.engines.rexx.RexxProxy;

public class Test_AbstractTest
{
    public void test_AbstractTest (AbstractTest test) throws Exception
    {

        RexxProxy rp=test.getTestRunner();
// System.err.println("rp=["+rp+"] <-- this instance's testRunner !, test=["+test+"]");

            // inverse value
        String hintText="test.boolean_Method(true)";
        Object argArray[]=null;
        if (test.boolean_Method(true)!=false)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception (hintText);
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="test.Boolean_Method(Boolean.TRUE).booleanValue()";
        if (test.Boolean_Method(Boolean.TRUE).booleanValue()!=false)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Boolean_Method(Boolean.TRUE).booleanValue()");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


            // half value, Rexx: value%2
            // boolean/Boolean
        //-------
        hintText="";
        if (test.byte_Method((byte)-128)!= -64)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.byte_Method(-128)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.byte_Method((byte)127)!=63)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.byte_Method(127)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Byte_Method(new Byte(Byte.MIN_VALUE)).byteValue()!= -64)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Byte_Method(new Byte(Byte.MIN_VALUE)).byteValue()");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
            if (test.Byte_Method(new Byte(Byte.MAX_VALUE)).byteValue()!=63)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Byte_Method(new Byte(Byte.MAX_VALUE)).byteValue()");
        }
            else
            {
                rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
            }


            // char/Character: return value unchanged
            //-------
            hintText="";
        if (test.char_Method('A')!=('A'))
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.char_Method('A')");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.char_Method('')!= (''))
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.char_Method('')");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

/* // these only would work, if Rexx was fully Unicode aware
        if (test.Character_Method(new Character(Character.MIN_VALUE))!= Character.MIN_VALUE)
        {
            throw new Exception ("test.Character_Method(new Character(Character.MIN_VALUE))");
        }

        if (test.Character_Method(new Character(Character.MAX_VALUE))!= Character.MAX_VALUE)
        {
            throw new Exception ("test.Character_Method(new Character(Character.MAX_VALUE))");
        }
*/
        //-------
        hintText="";
        if (test.Character_Method(new Character('A')).charValue()!= 'A')
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Character_Method(new Character('A'))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Character_Method(new Character('')).charValue()!= '')
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Character_Method(new Character(''))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


            // short/Short
        //-------
        hintText="";
        if (test.short_Method((short)-32768)!= -16384)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.short_Method(-32768)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.short_Method((short)32767)!= 16383)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.short_Method(32767)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Short_Method(new Short(Short.MIN_VALUE)).shortValue()!= -16384)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Short_Method(new Short(Short.MIN_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Short_Method(new Short(Short.MAX_VALUE)).shortValue()!= 16383)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Short_Method(new Short(Short.MAX_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }




            // int/Integer
        //-------
        hintText="";
        if (test.int_Method(-2147483648)!= -1073741824)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.int_Method(-2147483648)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.int_Method(2147483647)!= 1073741823)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.int_Method(2147483647)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Integer_Method(new Integer(Integer.MIN_VALUE)).intValue()!= -1073741824)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Integer_Method(new Integer(Integer.MIN_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Integer_Method(new Integer(Integer.MAX_VALUE)).intValue()!= 1073741823)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Integer_Method(new Integer(Integer.MAX_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


            // long/Long
        //-------
        hintText="";
        if (test.long_Method(-9223372036854775808L)!= -4611686018427387904L)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.long_Method(-2147483648)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.long_Method(9223372036854775807L)!= 4611686018427387903L)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.long_Method(2147483647)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Long_Method(new Long(Long.MIN_VALUE)).longValue()!= -4611686018427387904L)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Long_Method(new Long(Long.MIN_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Long_Method(new Long(Long.MAX_VALUE)).longValue()!= 4611686018427387903L)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Long_Method(new Long(Long.MAX_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }



            // float/Float: return same value
        //-------
        hintText="";
        if (test.float_Method(Float.MIN_VALUE)!= Float.MIN_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.float_Method(Float.MIN_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.float_Method(Float.MAX_VALUE)!= Float.MAX_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.float_Method(Float.MAX_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Float_Method(new Float(Float.MIN_VALUE)).floatValue()!= Float.MIN_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Float_Method(new Float(Float.MIN_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Float_Method(new Float(Float.MAX_VALUE)).floatValue()!= Float.MAX_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Float_Method(new Float(Float.MAX_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

            // double/Double: return same value
        //-------
        hintText="";
        if (test.double_Method(Double.MIN_VALUE)!= Double.MIN_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.double_Method(Double.MIN_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.double_Method(Double.MAX_VALUE)!= Double.MAX_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.double_Method(Double.MAX_VALUE)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="";
        if (test.Double_Method(new Double(Double.MIN_VALUE)).doubleValue()!= Double.MIN_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Double_Method(new Double(Double.MIN_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }

        //-------
        hintText="";
        if (test.Double_Method(new Double(Double.MAX_VALUE)).doubleValue()!= Double.MAX_VALUE)
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Double_Method(new Double(Double.MAX_VALUE))");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


            // String: returns last three chars
        //-------
        hintText="";
        if (! (test.String_Method("One, two, three").equals("ree")))
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.String_Method(\"One, two, three\")");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


           // String: returns supplied object
        //-------
        hintText="";
        if (test.Object_Method(this).hashCode()!=this.hashCode())
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.Object_Method(o).hashCode()");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


        //-------
        hintText="test.void_Method()";
           // just sendMessage the void test method
        test.void_Method();        // just sendMessage that method
        rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});


            // test all arguments, Rexx will return them as a concatenated string
        String strExpected=//"0 1 -3 3 A B -4 4 -5 5 -6 6 -7 7 -8 8";
                             "0 1 -3 3 A B -4 4 -5 5 -6 6 -7.0 7.0 -8.0 8.0";

        //-------
        hintText="!(test.all_args_Method(...)";
        if ( !(test.all_args_Method(
                     false          , Boolean.TRUE,
                     (byte) -3      , new Byte((byte)3),
                     'A'            , new Character('B'),
                     (short) -4     , new Short((short)4),
                     (int)   -5     , new Integer(5),
                             -6L    , new Long(6),
                             -7f    , new Float(7),
                             -8d    , new Double(8)

                                  ).equals(strExpected))
           )
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.FALSE, hintText});
            // throw new Exception ("test.all_args_Method(...)");
        }
        else
        {
            rp.sendMessage("assertTrue", new Object[] {Boolean.TRUE, hintText});
        }


    }
}


