   parse source . . path2this
   thisName=filespec('Name', path2this)

   bm = .bsf~new("org.apache.bsf.BSFManager")  -- get BSFManager
   re = bm~loadScriptingEngine("rexx")         -- let it load a RexxEngine
   rc = re~getRexxConfiguration                -- get the RexxConfiguration

   rh=.rexxDirectHandler~new   -- create Rexx object with the method "handleCommand"
      -- wrap/box the Rexx object in a Java object
   jh=BsfCreateRexxProxy(rh, , "org.rexxla.bsf.engines.rexx.AbstractDirectCommandHandler")

   -- configure Rexx instance that will be created when the first Rexx program runs
   environmentName="testRexxHandler"               -- environment name
   rc~addCommandHandler(environmentName, jh)       -- add command handler
   rc~initialAddressEnvironment(environmentName)   -- define default environment
   say rc~toString            -- display the RexxConfiguration as a string

   signal on syntax           -- for debug purposes
   re~apply(thisName"_resource_testProgram", 0, 0, .resources~testProgram~toString, .nil, .nil)
   return

syntax:
   co=condition('object')     -- get condition object (a directory)
   say .line":" ppJavaExceptionChain(co,.true)  -- let us show the whole story
   say "--"
   raise propagate            -- let Rexx do its thing as well


::requires "BSF.CLS"          -- get access to ooRexx-Java bridge

/* An implementation of a direct command handler in Rexx. */
::class rexxDirectHandler   -- this Rexx class implements the "handleCommand" method

/* All values that the command handler method returns will be made available
   via the RC variable upon return to the Rexx program employing the command
   handler.
*/
::method handleCommand        -- implements in Rexx the abstract Java method
   use arg slot, address, command, slotDir   -- get arguments

   -- a redirecting command handler has many default methods we may want to use:
   -- fetch the Java object such that we can send it directly messages
   javaObject=slotDir~javaObject    -- fetch the Java object from slotDir

   signal on syntax  -- for debugging purposes
   parse var command cmd remainder
   cmd=cmd~upper
   say "---> handleCommand("pp(address)","pp(command)") -> cmd="pp(cmd) "..."
      -- process the individual commands:
say 1/0
   select case cmd
       when "HELP"         then return "commands: HELP, REDIRECTABLE, TOSTRING, REVERSE, else received information gets returned"
       when "REVERSE"      then return command~reverse
       when "TOSTRING"     then return "settings:"       javaObject~toString(slot, address)
       when "REDIRECTABLE" then return "isRedirectable:" javaObject~isRedirectable
       otherwise                return "address="pp(address) "command="pp(command)
   end

syntax:
    co=condition('object')
    say .line":" ppJavaExceptionChain(co,.true)
    say "---"
    raise propagate

::method unknown              -- gets triggered by ooRexx if an unknown message is received
   use arg methName, msgArgs  -- fetch the information
   say .line self": UNKNOWN, methName="pp(methName) "msgArgs="pp(msgArgs~toString(,','))



/* This is the client Rexx program that will be run with the new Rexx instance
   that has the redirecting command handler defined (an instance of .rexxDirectHandler
-- Rexx program to run: it will employ the command handler
*/
::resource testProgram
   parse source . . name
   thisName=filespec('name',name)"_resource_testProgram"
   say thisName": arrived in testProgram"
      -- for the Rexx instance that runs this Rexx program the default environment got set
      -- command:
   "this is some command # 1 (will be given to default environment)"
   say "command handler returned:" pp(rc);say
   address testRexxHandler "this is some command # 2 (addressing environment explicitly)"
   say "command handler returned:" pp(rc);say
   "help"
   say "command handler returned:" pp(rc);say
   "reverse everything there is"
   say "command handler returned:" pp(rc);say
   "toString"
   say "command handler returned:" pp(rc);say
   "redirectable"
   say "command handler returned:" pp(rc);say
   ""
   say "command handler returned:" pp(rc);say
   "help"
   say "command handler returned:" pp(rc);say

   ::requires "BSF.CLS"    -- get ooRexx-Java bridge (this is a separate program)
::END

