#!/usr/bin/env rexx
dir=directory()"\bsf4rexx\rgf\*.testGroup"
say "dir:" dir "..."
say

call sysFileTree dir, "files.", "FOS"
say "dir    :" dir
say "files.0:" files.0
do i=1 to files.0
   say "files.i:" files.i
   call (files.i)
   say "-"~copies(79)
end

call show_statistics
say "---"
say "System~runFinalization ..."
.java.lang.System~runFinalization
call show_statistics
say "---"
say "System~gc ..."
.java.lang.System~gc
call show_statistics
say "---"
s=3
say "sleeping for" s "seconds ..."
call syssleep 3
call show_statistics
say "---"
/*
say "System~runFinalization ..."
.java.lang.System~runFinalization
say "sleeping for" s "seconds ..."
call syssleep 3
call show_statistics
say "---"
say "System~gc ..."
.java.lang.System~gc
say "sleeping for" s "seconds ..."
call syssleep 3
call show_statistics
*/

say "-"~copies(79)
l1=box('long',1230)
l2=box('long',4560)
l3=box('long',4560-1230)

strFormat="%-11s: instances=[%,15d] - finalized=[%,15d], not yet finalized=[%,15d]%n";
argArr=bsf.createJavaArrayOf("java.lang.Object", "Hello!", l1, l2, l3)
signal on syntax
say .java.lang.String~format(strFormat, argArr)

title="test by rgf"
clz=bsf.loadClass("java.util.Calendar")
str= .java.lang.String.format("RexxCleanupRef.getStatistics() [%1$tY-%1$tm-%1$td %1$tT.%1$tL]%n[%s]:%n", clz~getInstance, title)
say "title formatted, str:"
say str
say "---"


exit 0

syntax:
  co=condition('object')
  say ppJavaExceptionChain(co)


::routine show_statistics
   clz=bsf.loadClass("org.rexxla.bsf.engines.rexx.RexxCleanupRef")
   clzRefKind=clz~RefKind     -- get nested enum class
   cs=clz~getCounters
   len=max(length(clz~getCountInstances))+2

   totalInstances=0
   totalFinalizes=0
   do counter i en over clzRefKind
      inst=cs[en~ordinal+1,1]
      totalInstances+=inst
      fin =cs[en~ordinal+1,2]
      totalFinalizes+=fin
      str=en~name~left(11)": instances="pp(inst)~right(len) "-" -
                            "finalized="pp(fin)~right(len)", not yet finalized:" -
                            pp(inst-fin)~right(len)
      say str
   end
   say "-"~copies(79)
   say "Totals"~left(11,'.')": instances="pp(totalInstances)~right(len) "-" -
                              "finalized="pp(totalFinalizes)~right(len)", not yet finalized:" -
                              pp(totalInstances-totalFinalizes)~right(len)
   say
   say ".bsf4rexx~display.version:" .bsf4rexx~display.version
   say "bsfVersion()             :" bsfVersion()
   say

::requires bsf.cls