/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.lang.reflect.Array;
import org.apache.bsf.BSFException;
import org.rexxla.bsf.engines.rexx.RexxProxy;
import org.rexxla.bsf.engines.rexx.Supplier;

public class ArrayWrapper {
    public static String version = "106.20210205";
    private Object arrayObject = null;
    public int dimensions = 0;
    public int[] sizeOfDimension = null;
    public int items = 1;
    public Class componentType = null;

    public int dimension(int n) {
        return this.sizeOfDimension[n];
    }

    public ArrayWrapper(Object object) throws ClassNotFoundException, BSFException {
        Object object2;
        int n;
        if (!object.getClass().isArray()) {
            throw new BSFException(0, "ArrayWrapper(): \"" + object + "\" is not a Java array!");
        }
        this.arrayObject = object;
        int n2 = 0;
        String string = object.getClass().getName();
        n2 = string.length();
        for (n = 0; n < n2 && '[' == string.charAt(n); ++n) {
            ++this.dimensions;
        }
        char c = string.charAt(n);
        switch (c) {
            case 'I': {
                this.componentType = Integer.TYPE;
                break;
            }
            case 'C': {
                this.componentType = Character.TYPE;
                break;
            }
            case 'Z': {
                this.componentType = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.componentType = Byte.TYPE;
                break;
            }
            case 'D': {
                this.componentType = Double.TYPE;
                break;
            }
            case 'F': {
                this.componentType = Float.TYPE;
                break;
            }
            case 'S': {
                this.componentType = Short.TYPE;
                break;
            }
            case 'J': {
                this.componentType = Long.TYPE;
                break;
            }
            case 'L': {
                object2 = "";
                int n3 = n2 - 1;
                ++n;
                while (n < n3) {
                    object2 = (String)object2 + string.charAt(n);
                    ++n;
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    try {
                        this.componentType = classLoader.loadClass((String)object2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.componentType != null) break;
                this.componentType = ArrayWrapper.class.getClassLoader().loadClass((String)object2);
            }
        }
        this.sizeOfDimension = new int[this.dimensions];
        object2 = object;
        for (n = 0; n < this.dimensions; ++n) {
            this.sizeOfDimension[n] = Array.getLength(object2);
            this.items *= this.sizeOfDimension[n];
            if (this.sizeOfDimension[n] == 0) break;
            object2 = Array.get(object2, 0);
        }
    }

    public Object get(int[] nArray) {
        Object object = null;
        object = this.arrayObject;
        for (int i = 0; i < this.dimensions && i < nArray.length; ++i) {
            object = Array.get(object, nArray[i]);
        }
        return object;
    }

    public void put(Object object, int[] nArray) {
        int n;
        int n2 = this.dimensions - 1;
        Object object2 = null;
        object2 = this.arrayObject;
        for (n = 0; n < n2 && n < nArray.length; ++n) {
            object2 = Array.get(object2, nArray[n]);
        }
        Array.set(object2, nArray[n], object);
    }

    public Supplier supplier() {
        Object[] objectArray = this.makearray(true, false);
        return new Supplier((Object[])objectArray[0], (Object[])objectArray[1]);
    }

    public Supplier supplier(boolean bl) {
        Object[] objectArray = this.makearray(true, bl);
        return new Supplier((Object[])objectArray[0], (Object[])objectArray[1]);
    }

    public RexxProxy supplier(RexxProxy rexxProxy) throws BSFException {
        Object[] objectArray = this.makearray(true, true);
        return (RexxProxy)rexxProxy.sendMessage2("NEW", objectArray[0], objectArray[1]);
    }

    public synchronized Object[] makearray(boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.items;
        int[] nArray = new int[this.dimensions];
        String string = "";
        String string2 = "";
        Object object = null;
        Object object2 = this.arrayObject;
        Object[] objectArray = new Object[]{null, null};
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        objectArray2 = new Object[n5];
        if (bl) {
            objectArray3 = new Object[n5];
        }
        while (nArray[0] < this.sizeOfDimension[0]) {
            int n6;
            object2 = this.arrayObject;
            n2 = this.dimensions - 1;
            n = 0;
            while (n < n2) {
                object2 = Array.get(object2, nArray[n++]);
            }
            string = "";
            for (n6 = 0; n6 < this.dimensions - 1; ++n6) {
                string = bl2 ? string + (nArray[n6] + 1) + "," : string + "[" + nArray[n6] + "]";
            }
            for (n = 0; n < this.sizeOfDimension[n2]; ++n) {
                object = Array.get(object2, n);
                if (object == null) continue;
                string2 = bl2 ? "" + (n + 1) : "[" + n + "]";
                if (bl) {
                    objectArray3[n4] = string + string2;
                }
                objectArray2[n4++] = object;
            }
            n = this.dimensions - 2;
            if (n >= 0) {
                nArray[n] = nArray[n] + 1;
                if (nArray[n] >= this.sizeOfDimension[n]) {
                    for (n6 = n - 1; n6 >= 0; --n6) {
                        nArray[n6] = nArray[n6] + 1;
                        if (nArray[n6] >= this.sizeOfDimension[n6]) continue;
                        for (n3 = n6 + 1; n3 < this.dimensions; ++n3) {
                            nArray[n3] = 0;
                        }
                        break;
                    }
                }
            }
            if (this.dimensions != 1) continue;
        }
        if (n5 != n4) {
            Object[] objectArray4 = new Object[n4];
            Object[] objectArray5 = null;
            if (bl) {
                objectArray5 = new Object[n4];
            }
            for (n = 0; n < n4; ++n) {
                objectArray4[n] = objectArray2[n];
                if (!bl) continue;
                objectArray5[n] = objectArray3[n];
            }
            objectArray2 = objectArray4;
            objectArray3 = objectArray5;
        }
        objectArray[0] = objectArray2;
        objectArray[1] = objectArray3;
        return objectArray;
    }
}

