/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class StackMapFrameCodeStream
extends CodeStream {
    public int[] stateIndexes;
    public int stateIndexesCounter;
    private HashMap framePositions;
    public Set exceptionMarkers;
    public ArrayList stackDepthMarkers;
    public ArrayList stackMarkers;

    public StackMapFrameCodeStream(ClassFile classFile) {
        super(classFile);
        this.generateAttributes |= 0x10;
    }

    @Override
    public void addDefinitelyAssignedVariables(Scope scope, int n) {
        for (int i = 0; i < this.visibleLocalsCount; ++i) {
            boolean bl;
            LocalVariableBinding localVariableBinding = this.visibleLocals[i];
            if (localVariableBinding == null || !(bl = this.isDefinitelyAssigned(scope, n, localVariableBinding)) || localVariableBinding.initializationCount != 0 && localVariableBinding.initializationPCs[(localVariableBinding.initializationCount - 1 << 1) + 1] == -1) continue;
            localVariableBinding.recordInitializationStartPC(this.position);
        }
    }

    public void addExceptionMarker(int n, TypeBinding typeBinding) {
        if (this.exceptionMarkers == null) {
            this.exceptionMarkers = new HashSet();
        }
        this.exceptionMarkers.add(new ExceptionMarker(n, typeBinding));
    }

    public void addFramePosition(int n) {
        Integer n2 = n;
        FramePosition framePosition = (FramePosition)this.framePositions.get(n2);
        if (framePosition != null) {
            ++framePosition.counter;
        } else {
            this.framePositions.put(n2, new FramePosition());
        }
    }

    @Override
    public void optimizeBranch(int n, BranchLabel branchLabel) {
        super.optimizeBranch(n, branchLabel);
        this.removeFramePosition(n);
    }

    public void removeFramePosition(int n) {
        Integer n2 = n;
        FramePosition framePosition = (FramePosition)this.framePositions.get(n2);
        if (framePosition != null) {
            --framePosition.counter;
            if (framePosition.counter <= 0) {
                this.framePositions.remove(n2);
            }
        }
    }

    @Override
    public void addVariable(LocalVariableBinding localVariableBinding) {
        if (localVariableBinding.initializationPCs == null) {
            this.record(localVariableBinding);
        }
        localVariableBinding.recordInitializationStartPC(this.position);
    }

    @Override
    public void recordExpressionType(TypeBinding typeBinding, int n, boolean bl) {
        if (bl) {
            switch (typeBinding.id) {
                case 7: 
                case 8: {
                    this.stackDepth += 2;
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    ++this.stackDepth;
                }
            }
        }
    }

    @Override
    public void generateClassLiteralAccessForType(Scope scope, TypeBinding typeBinding, FieldBinding fieldBinding) {
        if (typeBinding.isBaseType() && typeBinding != TypeBinding.NULL) {
            this.getTYPE(typeBinding.id);
            return;
        }
        if (this.targetLevel >= 0x310000L) {
            this.ldc(typeBinding);
        } else {
            BranchLabel branchLabel = new BranchLabel(this);
            if (fieldBinding != null) {
                this.fieldAccess((byte)-78, fieldBinding, null);
                this.dup();
                this.ifnonnull(branchLabel);
                this.pop();
            }
            ExceptionLabel exceptionLabel = new ExceptionLabel(this, TypeBinding.NULL);
            exceptionLabel.placeStart();
            this.ldc(typeBinding == TypeBinding.NULL ? "java.lang.Object" : String.valueOf(typeBinding.constantPoolName()).replace('/', '.'));
            this.invokeClassForName();
            exceptionLabel.placeEnd();
            if (fieldBinding != null) {
                this.dup();
                this.fieldAccess((byte)-77, fieldBinding, null);
            }
            this.goto_(branchLabel);
            int n = this.stackDepth;
            this.pushExceptionOnStack(scope.getJavaLangClassNotFoundException());
            exceptionLabel.place();
            this.newNoClassDefFoundError();
            this.dup_x1();
            this.swap();
            this.invokeThrowableGetMessage();
            this.invokeNoClassDefFoundErrorStringConstructor();
            this.athrow();
            branchLabel.place();
            this.stackDepth = n;
        }
    }

    @Override
    public void generateOuterAccess(Object[] objectArray, ASTNode aSTNode, Binding binding, Scope scope) {
        int n = this.position;
        super.generateOuterAccess(objectArray, aSTNode, binding, scope);
        if (n == this.position) {
            throw new AbortMethod(scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    public ExceptionMarker[] getExceptionMarkers() {
        Set set = this.exceptionMarkers;
        if (this.exceptionMarkers == null) {
            return null;
        }
        int n = set.size();
        Object[] objectArray = new ExceptionMarker[n];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray[n2++] = (ExceptionMarker)iterator.next();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public int[] getFramePositions() {
        Set set = this.framePositions.keySet();
        int n = set.size();
        int[] nArray = new int[n];
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            nArray[n2++] = (Integer)iterator.next();
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public boolean hasFramePositions() {
        return this.framePositions.size() != 0;
    }

    @Override
    public void init(ClassFile classFile) {
        super.init(classFile);
        this.stateIndexesCounter = 0;
        if (this.framePositions != null) {
            this.framePositions.clear();
        }
        if (this.exceptionMarkers != null) {
            this.exceptionMarkers.clear();
        }
        if (this.stackDepthMarkers != null) {
            this.stackDepthMarkers.clear();
        }
        if (this.stackMarkers != null) {
            this.stackMarkers.clear();
        }
    }

    @Override
    public void initializeMaxLocals(MethodBinding methodBinding) {
        super.initializeMaxLocals(methodBinding);
        if (this.framePositions == null) {
            this.framePositions = new HashMap();
        } else {
            this.framePositions.clear();
        }
    }

    public void popStateIndex() {
        --this.stateIndexesCounter;
    }

    public void pushStateIndex(int n) {
        int n2;
        if (this.stateIndexes == null) {
            this.stateIndexes = new int[3];
        }
        if ((n2 = this.stateIndexes.length) == this.stateIndexesCounter) {
            this.stateIndexes = new int[n2 * 2];
            System.arraycopy(this.stateIndexes, 0, this.stateIndexes, 0, n2);
        }
        this.stateIndexes[this.stateIndexesCounter++] = n;
    }

    @Override
    public void removeNotDefinitelyAssignedVariables(Scope scope, int n) {
        int n2 = this.visibleLocalsCount;
        block0: for (int i = 0; i < n2; ++i) {
            boolean bl;
            LocalVariableBinding localVariableBinding = this.visibleLocals[i];
            if (localVariableBinding == null || localVariableBinding.initializationCount <= 0 || (bl = this.isDefinitelyAssigned(scope, n, localVariableBinding))) continue;
            if (this.stateIndexes != null) {
                int n3 = this.stateIndexesCounter;
                for (int j = 0; j < n3; ++j) {
                    if (this.isDefinitelyAssigned(scope, this.stateIndexes[j], localVariableBinding)) continue block0;
                }
            }
            localVariableBinding.recordInitializationEndPC(this.position);
        }
    }

    @Override
    public void reset(ClassFile classFile) {
        super.reset(classFile);
        this.stateIndexesCounter = 0;
        if (this.framePositions != null) {
            this.framePositions.clear();
        }
        if (this.exceptionMarkers != null) {
            this.exceptionMarkers.clear();
        }
        if (this.stackDepthMarkers != null) {
            this.stackDepthMarkers.clear();
        }
        if (this.stackMarkers != null) {
            this.stackMarkers.clear();
        }
    }

    @Override
    protected void writePosition(BranchLabel branchLabel) {
        super.writePosition(branchLabel);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    protected void writePosition(BranchLabel branchLabel, int n) {
        super.writePosition(branchLabel, n);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    protected void writeSignedWord(int n, int n2) {
        super.writeSignedWord(n, n2);
        this.addFramePosition(this.position);
    }

    @Override
    protected void writeWidePosition(BranchLabel branchLabel) {
        super.writeWidePosition(branchLabel);
        this.addFramePosition(branchLabel.position);
    }

    @Override
    public void areturn() {
        super.areturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void ireturn() {
        super.ireturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void lreturn() {
        super.lreturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void freturn() {
        super.freturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void dreturn() {
        super.dreturn();
        this.addFramePosition(this.position);
    }

    @Override
    public void return_() {
        super.return_();
        this.addFramePosition(this.position);
    }

    @Override
    public void athrow() {
        super.athrow();
        this.addFramePosition(this.position);
    }

    @Override
    public void pushExceptionOnStack(TypeBinding typeBinding) {
        super.pushExceptionOnStack(typeBinding);
        this.addExceptionMarker(this.position, typeBinding);
    }

    @Override
    public void goto_(BranchLabel branchLabel) {
        super.goto_(branchLabel);
        this.addFramePosition(this.position);
    }

    @Override
    public void goto_w(BranchLabel branchLabel) {
        super.goto_w(branchLabel);
        this.addFramePosition(this.position);
    }

    @Override
    public void resetInWideMode() {
        this.resetSecretLocals();
        super.resetInWideMode();
    }

    @Override
    public void resetForCodeGenUnusedLocals() {
        this.resetSecretLocals();
        super.resetForCodeGenUnusedLocals();
    }

    public void resetSecretLocals() {
        for (LocalVariableBinding localVariableBinding : this.locals) {
            if (localVariableBinding == null || !localVariableBinding.isSecret()) continue;
            localVariableBinding.resetInitializations();
        }
    }

    public static class ExceptionMarker
    implements Comparable {
        private TypeBinding binding;
        public int pc;

        public ExceptionMarker(int n, TypeBinding typeBinding) {
            this.pc = n;
            this.binding = typeBinding;
        }

        public int compareTo(Object object) {
            if (object instanceof ExceptionMarker) {
                return this.pc - ((ExceptionMarker)object).pc;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof ExceptionMarker) {
                ExceptionMarker exceptionMarker = (ExceptionMarker)object;
                return this.pc == exceptionMarker.pc && this.binding.equals(exceptionMarker.binding);
            }
            return false;
        }

        public TypeBinding getBinding() {
            return this.binding;
        }

        public int hashCode() {
            return this.pc + CharOperation.hashCode(this.binding.constantPoolName());
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(').append(this.pc).append(',').append(this.binding.constantPoolName()).append(')');
            return String.valueOf(stringBuffer);
        }
    }

    static class FramePosition {
        int counter;

        FramePosition() {
        }
    }
}

