/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.event.EventProcessor;

public class BSFEventProcessor
implements EventProcessor {
    BSFEngine engine;
    BSFManager manager;
    String filter;
    String source;
    int lineNo;
    int columnNo;
    Object script;

    BSFEventProcessor(BSFEngine bSFEngine, BSFManager bSFManager, String string, String string2, int n, int n2, Object object) throws BSFException {
        this.engine = bSFEngine;
        this.manager = bSFManager;
        this.filter = string;
        this.source = string2;
        this.lineNo = n;
        this.columnNo = n2;
        this.script = object;
    }

    @Override
    public void processEvent(String string, Object[] objectArray) {
        try {
            this.processExceptionableEvent(string, objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            System.err.println("BSFError: non-exceptionable event delivery threw exception (that's not nice): " + exception);
            exception.printStackTrace();
        }
    }

    @Override
    public void processExceptionableEvent(String string, Object[] objectArray) throws Exception {
        if (this.filter != null && !BSFEventProcessor.isFilteredEvent(this.filter, string)) {
            return;
        }
        this.engine.exec(this.source, this.lineNo, this.columnNo, this.script);
    }

    private static boolean isFilteredEvent(String string, String string2) {
        boolean bl = string.equalsIgnoreCase(string2);
        if (bl) {
            return bl;
        }
        String[] stringArray = string.replace('+', ' ').split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            bl = stringArray[i].equalsIgnoreCase(string2);
            if (!bl) continue;
            return bl;
        }
        return bl;
    }
}

