/*
 * Decompiled with CFR 0.152.
 */
package org.rexxla.bsf.engines.rexx;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.IdentityHashMap;
import org.rexxla.bsf.engines.rexx.RexxEngine;

public class RexxCleanupRef
extends PhantomReference {
    private static final boolean bDebug = false;
    private static boolean bDebugRII = false;
    private static boolean bDebugRexxProxy = false;
    public static final String version = "100.20220802";
    private static int cleanInvocationCounter = 0;
    private static final ReferenceQueue refQueue = new ReferenceQueue();
    public static final IdentityHashMap<RexxCleanupRef, Object> pinnedReferences = new IdentityHashMap();
    private static RefKind[] refkinds = (RefKind[])RefKind.class.getEnumConstants();
    private static long[][] counters = new long[refkinds.length][2];
    private static int gcThresholdMin = 1;
    private static int gcThresholdMax = 100;
    private static boolean gcTriggered = false;
    private static int gcThresholdIgnoreFor = 0;
    private static int gcThreshold = 100;
    private static boolean cleanerThreadRunning = false;
    static Runnable runnableCleaner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            RexxCleanupRef rexxCleanupRef = null;
            try {
                while ((rexxCleanupRef = (RexxCleanupRef)refQueue.remove()) != null) {
                    rexxCleanupRef.finalizeRexxObject();
                    rexxCleanupRef.clear();
                    Object object = pinnedReferences;
                    // MONITORENTER : object
                    pinnedReferences.remove(rexxCleanupRef);
                    // MONITOREXIT : object
                    long[][] lArray = counters;
                    object = lArray;
                    // MONITORENTER : lArray
                    long[] lArray2 = counters[rexxCleanupRef.refKind.ordinal()];
                    lArray2[1] = lArray2[1] + 1L;
                    // MONITOREXIT : object
                }
            }
            catch (Throwable throwable) {
                System.err.println("RexxCleanupRef.runnableCleaner(thread=" + Thread.currentThread().getName() + ") threw throwable: " + throwable);
            }
            cleanerThreadRunning = false;
        }
    };
    private final RefKind refKind;
    private final Object obj_id;
    static int testObjectCounter = 0;
    private static final String strFormatHeader_1 = "RexxCleanupRef [%1$tY-%1$tm-%1$td %1$tT.%1$tN]%n";
    private static final String strFormatHeader_2 = "RexxCleanupRef [%1$tY-%1$tm-%1$td %1$tT.%1$tN] [%2$s]%n";
    private static final String strFormatHeader_3 = String.format("%21s  %17s  %17s %18s%n", "RefKind:", "Instances:", "Finalized:", "Not Yet Finalized:");
    private static final String strFormatLineHeader = "%-20s";
    private static final String strFormatNumbers = ": [%,16d] [%,16d] [%,16d]%n";
    private static final String strDivider = String.format("%-78s%n", "").replace(' ', '-');

    public static boolean getDebugRII() {
        return bDebugRII;
    }

    public static void setDebugRII(boolean bl) {
        bDebugRII = bl;
    }

    public static boolean getDebugRexxProxy() {
        return bDebugRexxProxy;
    }

    public static void setDebugRexxProxy(boolean bl) {
        bDebugRexxProxy = bl;
    }

    public static int getCleanInvocationCounter() {
        return cleanInvocationCounter;
    }

    public static RefKind[] getRefkinds() {
        return refkinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[][] getCounters() {
        long[][] lArray = counters;
        synchronized (counters) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return (long[][])counters.clone();
        }
    }

    public static int getGcThresholdMin() {
        return gcThresholdMin;
    }

    public static void setGcThresholdMin(int n) {
        if (n >= 1 && n <= gcThresholdMax) {
            gcThresholdMin = n;
        }
    }

    public static int getGcThresholdMax() {
        return gcThresholdMax;
    }

    public static void setGcThresholdMax(int n) {
        if (n >= gcThresholdMin) {
            gcThresholdMax = n;
        }
    }

    public static int getGcThreshold() {
        return gcThreshold;
    }

    public static void setGcThreshold(int n) {
        if (n >= gcThresholdMin && n <= gcThresholdMax) {
            gcThresholdIgnoreFor = gcThreshold = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RexxCleanupRef(Object object, RefKind refKind, Object object2) {
        super(object, refQueue);
        this.refKind = refKind;
        this.obj_id = object2;
        boolean bl = false;
        IdentityHashMap<RexxCleanupRef, Object> identityHashMap = pinnedReferences;
        synchronized (identityHashMap) {
            pinnedReferences.put(this, null);
        }
        int n = refKind.ordinal();
        long[][] lArray = counters;
        synchronized (counters) {
            long[] lArray2 = counters[n];
            lArray2[0] = lArray2[0] + 1L;
            // ** MonitorExit[var6_8] (shouldn't be in output)
            if (refKind == RefKind.REXX_ENGINE) {
                int n2 = (int)(counters[n][0] - counters[n][1]);
                boolean bl2 = bl = n2 >= gcThreshold;
                if (bl) {
                    if (gcThresholdIgnoreFor > 0 || gcTriggered) {
                        gcTriggered = false;
                        if (--gcThresholdIgnoreFor <= 0) {
                            gcThresholdIgnoreFor = gcThreshold / 3;
                        }
                    } else {
                        gcTriggered = true;
                        gcThresholdIgnoreFor = 0;
                        System.gc();
                    }
                }
            }
            if (!cleanerThreadRunning) {
                RexxCleanupRef.startCleanerThread();
            }
            return;
        }
    }

    protected native int jniRexxTerminateInterpreterInstance(String var1);

    protected native int jniUnregisterRexxObject(String var1);

    private void finalizeRexxObject() {
        if (this.refKind == RefKind.REXX_ENGINE) {
            if (bDebugRII) {
                System.err.println("RexxCleanupRef.REXX_ENGINE: -> RII=[" + this.obj_id + "]");
            }
        } else if (this.refKind == RefKind.REXX_PROXY) {
            if (bDebugRexxProxy) {
                System.err.println("RexxCleanupRef.REXX_PROXY, RexxProxy: --> before jniUnregisterRexxObject(" + this.obj_id + ")");
            }
            int n = this.jniUnregisterRexxObject((String)this.obj_id);
            if (bDebugRexxProxy) {
                System.err.println("RexxCleanupRef.REXX_PROXY, RexxProxy: --> AFTER  jniUnregisterRexxObject(" + this.obj_id + ") remaining references=" + n + (n <= 0 ? " <-- removing" : ""));
            }
        } else if (this.refKind == RefKind.REXX_SCRIPT_ENGINE) {
            RexxEngine rexxEngine = (RexxEngine)this.obj_id;
            if (bDebugRII) {
                System.err.println("RexxCleanupRef.REXX_SCRIPT_ENGINE: re=[" + this.obj_id + "] ==> re.get_rii_ID=[" + rexxEngine.get_rii_ID() + "] [RE_" + rexxEngine.id + "]");
            }
            rexxEngine.terminate();
        }
    }

    private static synchronized void startCleanerThread() {
        if (!cleanerThreadRunning) {
            cleanerThreadRunning = true;
            String string = "RexxCleanupRef.runnableCleaner_" + ++cleanInvocationCounter;
            new Thread(runnableCleaner, string).start();
        }
    }

    public static void main(String[] stringArray) {
        class TestObject {
            TestObject() {
                RexxCleanupRef rexxCleanupRef = new RexxCleanupRef(this, RefKind.TEST, "clean infos for TestObject # " + ++testObjectCounter);
            }
        }
        ArrayList<TestObject> arrayList = new ArrayList<TestObject>();
        int n = 123456;
        System.out.println("RexxCleanupRef.main(): creating [" + n + "] TestObjects and storing them in an ArrayList ...\n");
        for (int i = 0; i < n; ++i) {
            TestObject testObject = new TestObject();
            arrayList.add(testObject);
        }
        System.err.println(RexxCleanupRef.getStatistics("main(): before nullifying"));
        System.out.println("... nullifying the ArrayList ...\n");
        arrayList = null;
        System.gc();
        System.err.println(RexxCleanupRef.getStatistics("after gc()"));
        try {
            System.runFinalization();
            System.err.println(RexxCleanupRef.getStatistics("after runFinalization()"));
        }
        catch (Throwable throwable) {
            System.err.println("exception while trying to run 'System.runFinalization()': " + throwable);
        }
        System.gc();
        System.err.println(RexxCleanupRef.getStatistics("after gc()"));
        int n2 = 500;
        System.err.println("main(): sleeping " + n2 + " ms");
        try {
            Thread.sleep(n2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.err.println(RexxCleanupRef.getStatistics("after sleeping " + n2 + " ms"));
        System.err.println("\nJava version used for this run: [" + System.getProperty("java.version") + "]");
        System.exit(0);
    }

    public static String getStatistics() {
        return RexxCleanupRef.getStatistics(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStatistics(String string) {
        long l = 0L;
        long l2 = 0L;
        String string2 = string == null || string.isEmpty() ? String.format(strFormatHeader_1, Calendar.getInstance()) : String.format(strFormatHeader_2, Calendar.getInstance(), string);
        string2 = string2 + strFormatHeader_3 + strDivider;
        long[][] lArray = counters;
        synchronized (counters) {
            String string3;
            String string4;
            for (RefKind refKind : refkinds) {
                string4 = String.format(strFormatLineHeader, '[' + refKind.name() + ']').replace(' ', '.');
                int n = refKind.ordinal();
                string3 = String.format(strFormatNumbers, counters[n][0], counters[n][1], counters[n][0] - counters[n][1]);
                string2 = string2 + string4 + string3;
                l += counters[n][0];
                l2 += counters[n][1];
            }
            string4 = String.format(strFormatLineHeader, "Totals").replace(' ', '.');
            string3 = String.format(strFormatNumbers, l, l2, l - l2);
            string2 = string2 + strDivider + string4 + string3;
            // ** MonitorExit[var8_4] (shouldn't be in output)
            return string2;
        }
    }

    public static enum RefKind {
        TEST,
        REXX_ENGINE,
        REXX_PROXY,
        REXX_SCRIPT_ENGINE;

    }
}

