/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.clock;

import eu.hansolo.enzo.clock.Clock;
import eu.hansolo.enzo.clock.ClockBuilder;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Demo
extends Application {
    private Clock clock1;
    private Clock clock2;
    private Clock clock3;
    private Clock clock4;
    private Clock clock5;
    private Clock clock6;
    private static int noOfNodes;

    public void init() {
        this.clock1 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.BOSCH)).text("San Francisco")).time(LocalTime.now().plus(Duration.of(-9L, ChronoUnit.HOURS)))).autoNightMode(false)).build();
        this.clock2 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.IOS6)).nightMode(true)).text("New York")).time(LocalTime.now().plus(Duration.of(-6L, ChronoUnit.HOURS)))).autoNightMode(true)).build();
        this.clock3 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.DB)).text("Berlin")).autoNightMode(true)).running(false)).build();
        this.clock4 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.DB)).nightMode(true)).text("Moskau")).time(LocalTime.now().plus(Duration.of(3L, ChronoUnit.HOURS)))).autoNightMode(true)).build();
        this.clock5 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.BRAUN)).discreteSecond(true)).text("Hongkong")).time(LocalTime.now().plus(Duration.of(7L, ChronoUnit.HOURS)))).autoNightMode(true)).build();
        this.clock6 = ((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)((ClockBuilder)ClockBuilder.create().prefSize(400.0, 400.0)).design(Clock.Design.BRAUN)).nightMode(true)).discreteSecond(true)).text("Sydney")).time(LocalTime.now().plus(Duration.of(10L, ChronoUnit.HOURS)))).autoNightMode(true)).build();
    }

    public void start(Stage stage) {
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setHgap(10.0);
        pane.setVgap(10.0);
        pane.add((Node)this.clock1, 0, 0);
        pane.add((Node)this.clock2, 0, 1);
        pane.add((Node)this.clock3, 1, 0);
        pane.add((Node)this.clock4, 1, 1);
        pane.add((Node)this.clock5, 2, 0);
        pane.add((Node)this.clock6, 2, 1);
        Scene scene = new Scene((Parent)pane, (Paint)Color.BLACK);
        stage.setTitle("Clock Demo");
        stage.setScene(scene);
        stage.show();
        Demo.calcNoOfNodes((Node)scene.getRoot());
        System.out.println("No. of nodes in scene: " + noOfNodes);
        for (Node node : pane.getChildren()) {
            ((Clock)node).setRunning(true);
        }
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Demo.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

