/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.qlocktwo;

import eu.hansolo.enzo.qlocktwo.Qlock;
import eu.hansolo.enzo.qlocktwo.QlockTwo;
import eu.hansolo.enzo.qlocktwo.QlockWord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class QlockGerman
implements Qlock {
    private static final QlockTwo.Language LANGUAGE = QlockTwo.Language.GERMAN;
    private static final String[][] MATRIX = new String[][]{{"E", "S", "K", "I", "S", "T", "A", "F", "\u00dc", "N", "F"}, {"Z", "E", "H", "N", "Z", "W", "A", "N", "Z", "I", "G"}, {"D", "R", "E", "I", "V", "I", "E", "R", "T", "E", "L"}, {"V", "O", "R", "F", "U", "N", "K", "N", "A", "C", "H"}, {"H", "A", "L", "B", "A", "E", "L", "F", "\u00dc", "N", "F"}, {"E", "I", "N", "S", "X", "\u00c4", "M", "Z", "W", "E", "I"}, {"D", "R", "E", "I", "A", "U", "I", "V", "I", "E", "R"}, {"S", "E", "C", "H", "S", "N", "L", "A", "C", "H", "T"}, {"S", "I", "E", "B", "E", "N", "Z", "W", "\u00d6", "L", "F"}, {"Z", "E", "H", "N", "E", "U", "N", "K", "U", "H", "R"}};
    private final ConcurrentHashMap<Integer, String> LOOKUP = new ConcurrentHashMap();
    private List<QlockWord> timeList;

    public QlockGerman() {
        this.LOOKUP.putAll(QlockTwo.Language.GERMAN.getLookup());
        this.timeList = new ArrayList<QlockWord>(10);
    }

    @Override
    public String[][] getMatrix() {
        return MATRIX;
    }

    @Override
    public List<QlockWord> getTime(int minute, int hour) {
        if (hour > 12) {
            hour -= 12;
        }
        if (hour <= 0) {
            hour += 12;
        }
        if (minute > 60) {
            minute -= 60;
            ++hour;
        }
        if (minute < 0) {
            minute += 60;
            --hour;
        }
        minute -= minute % 5;
        this.timeList.clear();
        this.timeList.add(QlockLanguage.ES);
        this.timeList.add(QlockLanguage.IST);
        switch (minute) {
            case 0: {
                if (10 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                } else if (1 == hour) {
                    this.timeList.add(QlockLanguage.EIN);
                } else if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                } else if (5 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                } else {
                    this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                }
                this.timeList.add(QlockLanguage.UHR);
                break;
            }
            case 5: {
                this.timeList.add(QlockLanguage.FUENF1);
                this.timeList.add(QlockLanguage.NACH);
                if (10 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                    break;
                }
                if (3 == hour) {
                    this.timeList.add(QlockLanguage.DREI1);
                    break;
                }
                if (5 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                    break;
                }
                if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                    break;
                }
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 10: {
                this.timeList.add(QlockLanguage.ZEHN);
                this.timeList.add(QlockLanguage.NACH);
                if (10 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                    break;
                }
                if (3 == hour) {
                    this.timeList.add(QlockLanguage.DREI1);
                    break;
                }
                if (5 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                    break;
                }
                if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                    break;
                }
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 15: {
                this.timeList.add(QlockLanguage.VIERTEL);
                this.timeList.add(QlockLanguage.NACH);
                if (10 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                    break;
                }
                if (3 == hour) {
                    this.timeList.add(QlockLanguage.DREI1);
                    break;
                }
                if (5 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                    break;
                }
                if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                    break;
                }
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 20: {
                this.timeList.add(QlockLanguage.ZWANZIG);
                this.timeList.add(QlockLanguage.NACH);
                if (10 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                    break;
                }
                if (3 == hour) {
                    this.timeList.add(QlockLanguage.DREI1);
                    break;
                }
                if (5 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                    break;
                }
                if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                    break;
                }
                this.timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(hour)));
                break;
            }
            case 25: {
                this.timeList.add(QlockLanguage.FUENF1);
                this.timeList.add(QlockLanguage.VOR);
                if (9 == hour) {
                    this.timeList.add(QlockLanguage.ZEHN1);
                } else if (2 == hour) {
                    this.timeList.add(QlockLanguage.DREI1);
                } else if (4 == hour) {
                    this.timeList.add(QlockLanguage.FUENF);
                } else if (11 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                }
                this.timeList.add(QlockLanguage.HALB);
                this.addHour(this.timeList, hour);
                break;
            }
            case 30: {
                this.timeList.add(QlockLanguage.HALB);
                this.addHour(this.timeList, hour);
                break;
            }
            case 35: {
                this.timeList.add(QlockLanguage.FUENF1);
                this.timeList.add(QlockLanguage.NACH);
                this.timeList.add(QlockLanguage.HALB);
                this.addHour(this.timeList, hour);
                break;
            }
            case 40: {
                this.timeList.add(QlockLanguage.ZWANZIG);
                this.timeList.add(QlockLanguage.VOR);
                this.addHour(this.timeList, hour);
                break;
            }
            case 45: {
                this.timeList.add(QlockLanguage.VIERTEL);
                this.timeList.add(QlockLanguage.VOR);
                this.addHour(this.timeList, hour);
                break;
            }
            case 50: {
                this.timeList.add(QlockLanguage.ZEHN);
                this.timeList.add(QlockLanguage.VOR);
                this.addHour(this.timeList, hour);
                break;
            }
            case 55: {
                this.timeList.add(QlockLanguage.FUENF1);
                this.timeList.add(QlockLanguage.VOR);
                if (12 == hour) {
                    this.timeList.add(QlockLanguage.ZWOELF);
                    break;
                }
                this.addHour(this.timeList, hour);
            }
        }
        return this.timeList;
    }

    @Override
    public QlockTwo.Language getLanguage() {
        return LANGUAGE;
    }

    private void addHour(List<QlockWord> timeList, int HOUR) {
        if (HOUR == 12) {
            timeList.add(QlockLanguage.EINS);
        } else if (HOUR + 1 == 5) {
            timeList.add(QlockLanguage.FUENF2);
        } else if (HOUR + 1 == 10) {
            timeList.add(QlockLanguage.ZEHN1);
        } else if (HOUR + 1 == 3) {
            timeList.add(QlockLanguage.DREI1);
        } else if (HOUR + 1 == 12) {
            timeList.add(QlockLanguage.ZWOELF);
        } else {
            timeList.add(QlockLanguage.valueOf(this.LOOKUP.get(HOUR + 1)));
        }
    }

    private static enum QlockLanguage implements QlockWord
    {
        EIN(5, 0, 2),
        EINS(5, 0, 3),
        ZWEI(5, 7, 10),
        DREI(2, 0, 3),
        DREI1(6, 0, 3),
        VIER(6, 7, 10),
        FUENF(4, 7, 10),
        FUENF1(0, 7, 10),
        FUENF2(4, 7, 10),
        SECHS(7, 0, 4),
        SIEBEN(8, 0, 5),
        ACHT(7, 7, 10),
        NEUN(9, 3, 6),
        ZEHN(1, 0, 3),
        ZEHN1(9, 0, 3),
        ELF(4, 5, 7),
        ZWOELF(8, 6, 10),
        ES(0, 0, 1),
        IST(0, 3, 5),
        VOR(3, 0, 2),
        NACH(3, 7, 10),
        VIERTEL(2, 4, 10),
        DREIVIERTEL(2, 0, 10),
        HALB(4, 0, 3),
        ZWANZIG(1, 4, 10),
        UHR(9, 8, 10);

        private final int ROW;
        private final int START;
        private final int STOP;

        private QlockLanguage(int ROW, int START, int STOP) {
            this.ROW = ROW;
            this.START = START;
            this.STOP = STOP;
        }

        @Override
        public int getRow() {
            return this.ROW;
        }

        @Override
        public int getStart() {
            return this.START;
        }

        @Override
        public int getStop() {
            return this.STOP;
        }
    }
}

