/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.radialmenu;

import eu.hansolo.enzo.radialmenu.RadialMenu;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class RadialMenuButton
extends Region {
    private static final double PREFERRED_SIZE = 45.0;
    private static final double MINIMUM_SIZE = 20.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    private static final PseudoClass OPEN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private static boolean clickable = true;
    private RadialMenu radialMenu;
    private BooleanProperty open;
    private Region symbol;
    private RotateTransition symbolRotate;

    public RadialMenuButton(RadialMenu RADIAL_MENU) {
        this.radialMenu = RADIAL_MENU;
        this.getStyleClass().setAll((Object[])new String[]{"menu-button"});
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0 || Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0) {
            this.setPrefSize(45.0, 45.0);
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(20.0, 20.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.setPickOnBounds(false);
        this.symbol = new Region();
        this.symbol.getStyleClass().add((Object)"symbol");
        this.symbol.setMouseTransparent(true);
        this.symbolRotate = new RotateTransition(Duration.millis((double)200.0), (Node)this.symbol);
        this.symbolRotate.setInterpolator(Interpolator.EASE_BOTH);
        this.getChildren().addAll((Object[])new Node[]{this.symbol});
    }

    private void registerListeners() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
        this.setOnMouseClicked(actionEvent -> this.setOpen(!this.isOpen()));
        this.symbolRotate.setOnFinished(actionEvent -> {
            clickable = true;
        });
    }

    public final boolean isOpen() {
        return null == this.open ? false : this.open.get();
    }

    public final void setOpen(boolean OPEN) {
        this.openProperty().set(OPEN);
    }

    public final BooleanProperty openProperty() {
        if (null == this.open) {
            this.open = new BooleanPropertyBase(false){

                protected void invalidated() {
                    RadialMenuButton.this.pseudoClassStateChanged(OPEN_PSEUDO_CLASS, this.get());
                }

                public void set(boolean OPEN) {
                    if (clickable) {
                        super.set(OPEN);
                        clickable = false;
                        RadialMenuButton.this.rotate();
                    }
                }

                public Object getBean() {
                    return RadialMenuButton.this;
                }

                public String getName() {
                    return "open";
                }
            };
        }
        return this.open;
    }

    private void rotate() {
        if (this.isOpen()) {
            this.symbolRotate.setFromAngle(0.0);
            this.symbolRotate.setToAngle(this.radialMenu.getOptions().isSimpleMode() ? -45.0 : -135.0);
        } else {
            this.symbolRotate.setFromAngle(this.radialMenu.getOptions().isSimpleMode() ? -45.0 : -135.0);
            this.symbolRotate.setToAngle(0.0);
        }
        this.symbolRotate.play();
    }

    private void resize() {
        this.symbol.setPrefSize(0.44444 * this.getPrefWidth(), 0.44444 * this.getPrefHeight());
        this.symbol.relocate((this.getPrefWidth() - this.symbol.getPrefWidth()) * 0.5, (this.getPrefHeight() - this.symbol.getPrefHeight()) * 0.5);
    }
}

