/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.njpipes.stages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.netrexx.njpipes.pipes.StageError;
import org.netrexx.njpipes.pipes.ThreadQ;
import org.netrexx.njpipes.pipes.stage;

public class unzip
extends stage {
    private static final Rexx $01 = Rexx.toRexx("");
    private static final Rexx $02 = new Rexx(12);
    private static final Rexx $03 = new Rexx(0);
    private static final Rexx $04 = new Rexx('\n');
    private static final Rexx $05 = Rexx.toRexx("*/\n");
    private static final String $0 = "unzip.nrx";
    private ArrayList zipEntries;
    private Rexx zipFileName = Rexx.toRexx("");

    @Override
    public void run() throws ThreadQ {
        Rexx rexx = null;
        int n = 0;
        Rexx rexx2 = this.arg();
        try {
            if (rexx2.OpEq(null, $01)) {
                rexx2 = (Rexx)this.readto();
            }
        }
        catch (StageError stageError) {
            RexxIO.Say("unzip error");
        }
        if (rexx2.OpNotEq(null, $01)) {
            this.zipFileName = rexx2;
        }
        this.zipEntries = new ArrayList();
        try {
            while (true) {
                rexx = (Rexx)this.peekto();
                this.zipEntries.add(rexx);
                this.readto();
            }
        }
        catch (StageError stageError) {
            n = this.rc();
            try {
                this.extractFilesFromZip(this.zipFileName, this.zipEntries);
            }
            catch (FileNotFoundException fileNotFoundException) {
                RexxIO.Say("file not found");
            }
            catch (IOException iOException) {
                RexxIO.Say("I/O Exception");
            }
            this.exit(new Rexx(n).OpMult(null, new Rexx(new Rexx(n).OpNotEq(null, $02))).toint());
            return;
        }
    }

    public void extractFilesFromZip(Rexx rexx, ArrayList arrayList) throws FileNotFoundException, IOException {
        File file2 = null;
        FileOutputStream fileOutputStream = null;
        int n = 0;
        StageError stageError = null;
        ThreadQ threadQ = null;
        byte[] byArray = new byte[1024];
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(Rexx.toString(rexx)));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (!new Rexx(arrayList.contains(Rexx.toRexx(zipEntry.getName()))).OpNot(null)) {
                zipEntry = zipInputStream.getNextEntry();
                continue;
            }
            file2 = new File(zipEntry.getName());
            fileOutputStream = new FileOutputStream(file2);
            n = zipInputStream.read(byArray);
            while (new Rexx(n).OpGt(null, $03)) {
                fileOutputStream.write(byArray, 0, n);
                n = zipInputStream.read(byArray);
            }
            fileOutputStream.close();
            try {
                this.output(zipEntry.getName());
            }
            catch (StageError stageError2) {
                stageError = stageError2;
                RexxIO.Say(stageError.getMessage());
            }
            catch (ThreadQ threadQ2) {
                threadQ = threadQ2;
                RexxIO.Say(threadQ.getMessage());
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.closeEntry();
        zipInputStream.close();
    }

    public static Rexx givehelp() {
        return Rexx.toRexx("/** unzip -- Extract Files From a ZIP Archive\n").OpCcblank(null, $04).OpCcblank(null, Rexx.toRexx(">>--UNZIP--+---------------+--><\n")).OpCcblank(null, Rexx.toRexx("           +--filename-(1)-+\n")).OpCcblank(null, $04).OpCcblank(null, Rexx.toRexx("(1) If filename is not specified, it is read from the primary input stream.\n")).OpCcblank(null, Rexx.toRexx("    Succeeding input objects are ignored.\n")).OpCcblank(null, Rexx.toRexx("(2) The extracted file names are passed to the primary output stream.\n")).OpCcblank(null, Rexx.toRexx("(3) Any existing files will be replaced.\n")).OpCcblank(null, Rexx.toRexx("(4) This is a NetRexx Pipelines only stage.\n")).OpCcblank(null, $04).OpCcblank(null, $05);
    }
}

