/* usage: runTestUnits [-r[ecursive]] [directory]                             */
parse arg switch +2                 /* parse optional switch                  */

hint="Processed"                    /* used in title for brief results below  */
switches="FO"                       /* SysFileTree()-switches                 */
if switch~translate="-R" then       /* the "-R"[ecursive] switch in hand?     */
do
   switches=switches || "S"         /* add "S" switch for SysFileTree()       */
   parse arg . directory            /* parse optional directory               */
   hint=hint pp(switch)             /* used in title for brief results below  */
end
else
   parse arg directory              /* parse optional directory               */

   /* if running on Windows or OS2, then "\", "/" else   */
dirSlash=iif( pos(left(sysVersion(),1)~translate, "WO")>0, "\", "/")

if directory="" then directory="."        /* default to current directory     */
else if right(directory,1)=dirSlash then  /* remove possible trailing slash   */
   directory=directory~left(length(directory)-1)

searchFile=directory || dirSlash || "*.testUnit"   /* find all testUnit files */
call sysFileTree searchFile, "tests.", switches    /* search files            */
hint2="found" pp(tests.0) "file(s)" /* hint at the number of found files      */

list=.list~new                      /* create list of filenames               */
do i=1 to tests.0                   /* loop over found files                  */
   list~insert(tests.i)
end

ts=makeTestSuiteFromFileList(list)  /* create testSuite object from file list */
testResult=ts~run                   /* run all the tests in the testSuite     */

   /* show test results as brief results  */
call simpleDumpTestResults testResult, hint pp(searchFile)"," hint2

::requires ooRexxUnit.cls

