# Documentation

* [For The Unicode Tools Of Rexx (TUTOR, this file)](../).
* [For RXU, the Rexx Preprocessor for Unicode](./rxu/)
  * [New types of strings](./string-types/)
  * [Revised built-in functions](./built-in/)
    * [Stream functions for Unicode](./stream/)
    * [The encoding/decoding model](https://rexx.epbcn.com/TUTOR/doc/encodings/)
  * [New built-in functions](./new-functions/)
    * [The properties model](./properties/)
      * [The Unicode.Normalization class](./properties/normalization/).
  * [New classes](./new-classes/)
  * [New values for the OPTIONS instruction](./options/)
  * Utility packages
    * [The MultiStageTable class](./multi-stage-table/)
    * [The PersistentStringTable class](./persistent-string-table/)
* [Using TUTOR from Classic Rexx](./using-tutor-from-classic-rexx/)

## Publications

* [Unicode and Rexx. A brief introduction to TUTOR](https://www.epbcn.com/pdf/josep-maria-blasco/2025-05-04-Unicode-and-Rexx.pdf) (20250504;
  see also [as a web page](/TUTOR/doc/publications/36/2025-05-04-Unicode-and-Rexx/)). Presented to the
  [36th International Rexx Language Symposium -- Vienna, Austria and online](https://www.rexxla.org/events/schedule.rsp?year=2025).
* [The Unicode Tools of Rexx (TUTOR)](https://www.epbcn.com/pdf/josep-maria-blasco/2024-03-04-The-Unicode-Tools-Of-Rexx.pdf) (20240304).
  Presented to the
  [35th International Rexx Language Symposium -- Brisbane, Australia and online](https://www.rexxla.org/events/schedule.rsp?year=2024).

## Older releases

- [Release notes for version 0.6, 20250215](0.6-release-notes.md)
- [Release notes for version 0.5, 20240307](0.5-release-notes.md)
- [Release notes for version 0.4a, 20231002](0.4a-release-notes.md)
- [Release notes for version 0.4, 20230901](0.4-release-notes.md)
- [Release notes for version 0.3b, 20230817](0.3b-release-notes.md)
- [Release notes for version 0.3, 20230811](0.3-release-notes.md)
- [Release notes for version 0.2, 20230726](0.2-release-notes.md)
- [Release notes for version 0.1d, 20230719](0.1d-release-notes.md)
- [Release notes for version 0.1, 20230716](0.1-release-notes.md)
- [A toy ooRexx implementation of the General_Category Unicode property (20230711)](pre-0.1-release-notes.md)

