/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netrexx.lang.Rexx;
import netrexx.lang.RexxIO;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.netrexx.process.NetRexxC;

public class NetRexx
extends MatchingTask {
    private static final Rexx $01 = new Rexx(0);
    private static final Rexx $02 = Rexx.toRexx((String)"-no");
    private static final Rexx $03 = new Rexx('-');
    private static final String $0 = "NetRexx.nrx";
    private String arg;
    private String annotations;
    private String binary;
    private String comments;
    private String compact;
    private String compile;
    private boolean compile_b;
    private String console;
    private String crossref;
    private String decimal;
    private File destDir;
    private String diag;
    private String explicit;
    private String exec;
    private boolean exec_b;
    private String format;
    private String javacompiler;
    private String java_;
    private boolean java_b;
    private File javaDir;
    private String keep;
    private boolean keep_b;
    private String keepasjava;
    private boolean keepasjava_b;
    private String logo;
    private String replace;
    private String savelog;
    private File srcDir;
    private String sourcedir;
    private boolean sourcedir_b;
    private String strictargs;
    private String strictassign;
    private String strictcase;
    private String strictimport;
    private String strictprops;
    private String strictsignal;
    private String symbols;
    private String time;
    private String utf8;
    private String warnexit0;
    private boolean suppressMethodArgumentNotUsed = false;
    private boolean suppressPrivatePropertyNotUsed = false;
    private boolean suppressVariableNotUsed = false;
    private boolean suppressExceptionNotSignalled = false;
    private boolean suppressDeprecation = false;
    private boolean removeKeepExtension = false;
    private boolean removeSourceCopies = false;
    private Vector compileList = new Vector();
    private Hashtable filecopyList = new Hashtable();
    private String trace_ = "trace2";
    private String verbose = "verbose3";
    private Path compileClasspath;
    private String classpath;
    protected static String MSG_METHOD_ARGUMENT_NOT_USED = "Warning: Method argument is not used";
    protected static String MSG_PRIVATE_PROPERTY_NOT_USED = "Warning: Private property is defined but not used";
    protected static String MSG_VARIABLE_NOT_USED = "Warning: Variable is set but not used";
    protected static String MSG_EXCEPTION_NOT_SIGNALLED = "is in SIGNALS list but is not signalled within the method";
    protected static String MSG_DEPRECATION = "has been deprecated";

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setTrace(String string) {
        if (Rexx.toRexx((String)"trace trace1 trace2 notrace").wordpos(Rexx.toRexx((String)string)).OpEq(null, $01)) {
            this.log("Trace value not recognized - changing to trace");
            string = "trace";
        }
        this.trace_ = string;
    }

    public void setVerbose(String string) {
        if (Rexx.toRexx((String)"verbose verbose0 verbose1 verbose2 verbose3 verbose4 verbose5 noverbose").wordpos(Rexx.toRexx((String)string)).OpEq(null, $01)) {
            this.log("Verbose value not recognized - changing to verbose");
            string = "verbose";
        }
        this.verbose = string;
    }

    public void setJava(String string) {
        this.setJava_(string);
    }

    public void init() {
        Project project = this.getProject();
        String string = project.getProperty("ant.netrexxc.arg");
        if (string != null) {
            this.setArg(string);
        }
        if ((string = project.getProperty("ant.netrexxc.annotations")) != null) {
            this.annotations = string;
        }
        if ((string = project.getProperty("ant.netrexxc.binary")) != null) {
            this.binary = string;
        }
        if ((string = project.getProperty("ant.netrexxc.comments")) != null) {
            this.comments = string;
        }
        if ((string = project.getProperty("ant.netrexxc.compact")) != null) {
            this.compact = string;
        }
        if ((string = project.getProperty("ant.netrexxc.compile")) != null) {
            this.compile = string;
        }
        if ((string = project.getProperty("ant.netrexxc.console")) != null) {
            this.console = string;
        }
        if ((string = project.getProperty("ant.netrexxc.crossref")) != null) {
            this.crossref = string;
        }
        if ((string = project.getProperty("ant.netrexxc.decimal")) != null) {
            this.decimal = string;
        }
        if ((string = project.getProperty("ant.netrexxc.diag")) != null) {
            this.diag = string;
        }
        if ((string = project.getProperty("ant.netrexxc.explicit")) != null) {
            this.explicit = string;
        }
        if ((string = project.getProperty("ant.netrexxc.exec")) != null) {
            this.exec = string;
        }
        if ((string = project.getProperty("ant.netrexxc.format")) != null) {
            this.format = string;
        }
        if ((string = project.getProperty("ant.netrexxc.java")) != null) {
            this.java_ = string;
        }
        if ((string = project.getProperty("ant.netrexxc.keep")) != null) {
            this.keep = string;
        }
        if ((string = project.getProperty("ant.netrexxc.keepasjava")) != null) {
            this.keepasjava = string;
        }
        if ((string = project.getProperty("ant.netrexxc.logo")) != null) {
            this.logo = string;
        }
        if ((string = project.getProperty("ant.netrexxc.replace")) != null) {
            this.replace = string;
        }
        if ((string = project.getProperty("ant.netrexxc.savelog")) != null) {
            this.replace = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictargs")) != null) {
            this.strictargs = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictassign")) != null) {
            this.strictassign = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictcase")) != null) {
            this.strictcase = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictimport")) != null) {
            this.strictimport = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictprops")) != null) {
            this.strictprops = string;
        }
        if ((string = project.getProperty("ant.netrexxc.strictsignal")) != null) {
            this.strictsignal = string;
        }
        if ((string = project.getProperty("ant.netrexxc.symbols")) != null) {
            this.symbols = string;
        }
        if ((string = project.getProperty("ant.netrexxc.time")) != null) {
            this.time = string;
        }
        if ((string = project.getProperty("ant.netrexxc.trace")) != null) {
            this.setTrace(string);
        }
        if ((string = project.getProperty("ant.netrexxc.utf8")) != null) {
            this.utf8 = string;
        }
        if ((string = project.getProperty("ant.netrexxc.verbose")) != null) {
            this.setVerbose(string);
        }
        if ((string = project.getProperty("ant.netrexxc.warnexit0")) != null) {
            this.warnexit0 = string;
        }
        if ((string = project.getProperty("ant.netrexxc.suppressMethodArgumentNotUsed")) != null) {
            this.suppressMethodArgumentNotUsed = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.suppressPrivatePropertyNotUsed")) != null) {
            this.suppressPrivatePropertyNotUsed = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.suppressVariableNotUsed")) != null) {
            this.suppressVariableNotUsed = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.suppressExceptionNotSignalled")) != null) {
            this.suppressExceptionNotSignalled = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.suppressDeprecation")) != null) {
            this.suppressDeprecation = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.removeKeepExtension")) != null) {
            this.removeKeepExtension = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("ant.netrexxc.removeSourceCopies")) != null) {
            this.removeSourceCopies = Project.toBoolean((String)string);
        }
        if ((string = project.getProperty("nrx.compiler")) != null) {
            this.javacompiler = string;
        }
        if ((string = project.getProperty("ant.netrexxc.javacompiler")) != null) {
            this.javacompiler = string;
        }
    }

    public void checkoptions() {
        if (this.javacompiler != null) {
            System.setProperty("nrx.compiler", this.javacompiler);
        } else {
            System.clearProperty("nrx.compiler");
        }
        this.compile_b = this.compile == null ? false : Project.toBoolean((String)this.compile);
        this.exec_b = this.exec == null ? false : Project.toBoolean((String)this.exec);
        this.java_b = this.java_ == null ? false : Project.toBoolean((String)this.java_);
        this.keep_b = this.keep == null ? false : Project.toBoolean((String)this.keep);
        this.keepasjava_b = this.keepasjava == null ? false : Project.toBoolean((String)this.keepasjava);
        if (this.sourcedir == null) {
            this.sourcedir_b = true;
            this.sourcedir = "true";
        } else {
            this.sourcedir_b = Project.toBoolean((String)this.sourcedir);
        }
        if (this.crossref == null) {
            this.crossref = "false";
        }
        if (this.console == null) {
            this.console = "false";
        }
        if (!this.compile_b && !this.exec_b & this.arg == null && !this.java_b) {
            this.compile_b = true;
        }
    }

    public void execute() throws BuildException {
        this.checkoptions();
        String string = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        if (string != null) {
            this.log("RexxLA Ant NetRexx task " + string, 3);
        }
        if (this.destDir == null & !this.compile_b) {
            this.destDir = this.javaDir;
        }
        if (this.destDir == null) {
            this.destDir = this.srcDir;
        }
        if (this.javaDir == null) {
            this.javaDir = this.destDir;
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, stringArray);
        this.copyFilesToDestination();
        if (this.compileList.size() > 0) {
            if (this.compileList.size() == 1) {
                this.log("Compiling one (1) source file to " + this.destDir.toString());
            } else {
                this.log("Compiling " + this.compileList.size() + " source files to " + this.destDir.toString());
            }
            this.doNetRexxCompile();
            if (this.removeKeepExtension & (!this.compile_b | this.keep_b)) {
                this.removeKeepExtensions();
            }
            if (!this.javaDir.equals(this.destDir)) {
                this.movejavafiles();
            }
            if (!this.sourcedir_b) {
                this.moveclassfiles();
            }
            if (this.removeSourceCopies && !this.destDir.equals(this.srcDir)) {
                this.erasesourcecopies();
            }
        }
    }

    public void scanDir(File file, File file2, String[] stringArray) {
        int n = 0;
        File file3 = null;
        File file4 = null;
        String string = null;
        File file5 = null;
        File file6 = null;
        int n2 = stringArray.length - 1;
        for (n = 0; n <= n2; ++n) {
            file3 = new File(file, stringArray[n]);
            file4 = new File(file2, stringArray[n]);
            string = stringArray[n];
            if (string.toLowerCase().endsWith(".nrx")) {
                if (n == 0 && this.exec_b) {
                    this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
                    this.compileList.addElement(file4.getAbsolutePath());
                    this.log("Exec: " + file4.getAbsolutePath());
                    continue;
                }
                file5 = new File(file2, string.substring(0, string.lastIndexOf(".")) + ".class");
                file6 = this.keepasjava_b ? new File(this.javaDir, string.substring(0, string.lastIndexOf(".")) + ".java") : new File(this.javaDir, Rexx.toString((Rexx)Rexx.toRexx((String)string.substring(0, string.lastIndexOf("."))).OpCc(null, Rexx.toRexx((String)".java.keep .java").word(new Rexx((this.removeKeepExtension ? 1 : 0) + 1)))));
                if (!this.compile_b & file3.lastModified() > file6.lastModified()) {
                    this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
                    this.compileList.addElement(file4.getAbsolutePath());
                    continue;
                }
                if (!(this.compile_b & file3.lastModified() > file5.lastModified())) continue;
                this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
                this.compileList.addElement(file4.getAbsolutePath());
                continue;
            }
            if (file3.lastModified() <= file4.lastModified()) continue;
            this.filecopyList.put(file3.getAbsolutePath(), file4.getAbsolutePath());
        }
    }

    private void copyFilesToDestination() {
        String string = null;
        File file = null;
        String string2 = null;
        File file2 = null;
        IOException iOException = null;
        String string3 = null;
        if (this.srcDir.getAbsolutePath().equals(this.destDir.getAbsolutePath())) {
            return;
        }
        if (this.filecopyList.size() == 0) {
            return;
        }
        if (this.filecopyList.size() == 1) {
            this.log("Copying one (1) file to " + this.destDir.getAbsolutePath());
        } else {
            this.log("Copying " + this.filecopyList.size() + " files to " + this.destDir.getAbsolutePath());
        }
        Enumeration enumeration = this.filecopyList.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            file = new File(string);
            string2 = (String)this.filecopyList.get(string);
            if (string2 == null) {
                RexxIO.Say((String)"toFilename is null");
            }
            file2 = new File(string2);
            try {
                FileUtils.getFileUtils().copyFile(file, file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                string3 = "Failed to copy " + file.toString() + " to " + file2.toString() + " due to " + iOException.getMessage();
                throw new BuildException(string3, (Throwable)iOException);
            }
        }
    }

    public void erasesourcecopies() {
        Enumeration enumeration = null;
        String string = null;
        File file = null;
        if (this.srcDir.getAbsolutePath().equals(this.destDir.getAbsolutePath())) {
            return;
        }
        if (this.compileList.size() > 0) {
            this.log("Erasing copied source files from destDir");
            enumeration = this.compileList.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                file = new File(string);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    public void movejavafiles() {
        Enumeration enumeration = null;
        String string = null;
        String string2 = null;
        File file = null;
        String string3 = null;
        File file2 = null;
        IOException iOException = null;
        String string4 = null;
        if (this.compileList.size() > 0) {
            this.log("Moving java files to javaDir");
            enumeration = this.compileList.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = string.substring(0, string.lastIndexOf("."));
                file = new File(string2 + ".java.keep");
                if (!file.exists()) {
                    file = new File(string2 + ".java");
                }
                if (!file.exists()) continue;
                try {
                    string3 = file.getName();
                    file2 = new File(this.javaDir.getPath() + "/" + string3);
                    FileUtils.getFileUtils().copyFile(file, file2);
                    file.delete();
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    string4 = "Failed to move " + file.toString() + " to " + file2.toString() + " due to " + iOException.getMessage();
                    throw new BuildException(string4, (Throwable)iOException);
                }
            }
        }
    }

    public void moveclassfiles() {
        Enumeration enumeration = null;
        String string = null;
        File file = null;
        String string2 = null;
        File file2 = null;
        String string3 = null;
        File file3 = null;
        IOException iOException = null;
        String string4 = null;
        String string5 = this.getProject().getProperty("user.dir");
        if (string5 == null) {
            return;
        }
        File file4 = new File(string5);
        if (file4.getAbsolutePath().equals(this.destDir.getAbsolutePath())) {
            return;
        }
        if (this.srcDir.getAbsolutePath().equals(this.destDir.getAbsolutePath())) {
            return;
        }
        if (this.compileList.size() > 0) {
            this.log("Moving class files to destDir");
            enumeration = this.compileList.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                file = new File(string);
                string = file.getName();
                string2 = string.substring(0, string.lastIndexOf("."));
                file2 = new File(string5 + "/" + string2 + ".class");
                if (!file2.exists()) continue;
                try {
                    string3 = file2.getName();
                    file3 = new File(this.destDir.getPath() + "/" + string3);
                    FileUtils.getFileUtils().copyFile(file2, file3);
                    file2.delete();
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    string4 = "Failed to move " + file2.toString() + " to " + file3.toString() + " due to " + iOException.getMessage();
                    throw new BuildException(string4, (Throwable)iOException);
                }
            }
        }
    }

    public void removeKeepExtensions() {
        Enumeration enumeration = null;
        String string = null;
        String string2 = null;
        File file = null;
        File file2 = null;
        if (this.compileList.size() > 0) {
            this.log(Rexx.toString((Rexx)Rexx.toRexx((String)("Removing .keep extension on  " + this.compileList.size() + "  file")).OpCc(null, new Rexx('s').word(new Rexx((this.compileList.size() == 1 ? 1 : 0) + 1)))));
            enumeration = this.compileList.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = string.substring(0, string.lastIndexOf("."));
                file = new File(string2 + ".java.keep");
                if (file.renameTo(file2 = new File(string2 + ".java"))) {
                    this.log("Successfully renamed  " + file.toString() + "  to  " + file2.toString(), 3);
                    continue;
                }
                this.log("Failed to rename  " + file.toString() + "  to  " + file2.toString());
            }
        }
    }

    private void doNetRexxCompile() throws BuildException {
        int n = 0;
        ClassLoader classLoader = null;
        StringWriter stringWriter = null;
        int n2 = 0;
        BufferedReader bufferedReader = null;
        String string = null;
        Rexx rexx = null;
        Exception exception = null;
        this.log("Using NetRexx compiler", 3);
        this.classpath = this.getCompileClasspath();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = this.getCompileOptionsAsArrayList();
        String[] stringArray = new String[this.compileList.size()];
        Enumeration enumeration = this.compileList.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n3] = (String)enumeration.nextElement();
            ++n3;
        }
        String[] stringArray2 = new String[arrayList.size() + stringArray.length];
        int n4 = stringArray.length - 1;
        for (n = 0; n <= n4; ++n) {
            stringArray2[n] = stringArray[n];
        }
        n4 = arrayList.size() - 1;
        for (n = 0; n <= n4; ++n) {
            stringArray2[n + stringArray.length] = (String)arrayList.get(n);
        }
        stringBuffer.append("Compilation args: ");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            stringBuffer.append(' ');
        }
        this.log(stringBuffer.toString(), 3);
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer("Files to be compiled" + string2);
        n4 = this.compileList.size() - 1;
        for (n = 0; n <= n4; ++n) {
            stringBuffer2.append("    ");
            stringBuffer2.append(this.compileList.elementAt(n).toString());
            stringBuffer2.append(string2);
        }
        this.log(stringBuffer2.toString(), 3);
        this.log("Classpath:" + this.classpath, 3);
        String string3 = System.getProperty("java.class.path");
        Properties properties = System.getProperties();
        properties.put("java.class.path", this.classpath);
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            stringWriter = new StringWriter();
            n2 = NetRexxC.main2((String[])stringArray2, (PrintWriter)new PrintWriter(stringWriter));
            Thread.currentThread().setContextClassLoader(classLoader);
            bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            while ((string = bufferedReader.readLine()) != null) {
                rexx = new Rexx(string);
                if (this.suppressMethodArgumentNotUsed & rexx.pos(Rexx.toRexx((String)MSG_METHOD_ARGUMENT_NOT_USED)).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 3);
                    continue;
                }
                if (this.suppressPrivatePropertyNotUsed & rexx.pos(Rexx.toRexx((String)MSG_PRIVATE_PROPERTY_NOT_USED)).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 3);
                    continue;
                }
                if (this.suppressVariableNotUsed & rexx.pos(Rexx.toRexx((String)MSG_VARIABLE_NOT_USED)).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 3);
                    continue;
                }
                if (this.suppressExceptionNotSignalled & rexx.pos(Rexx.toRexx((String)MSG_EXCEPTION_NOT_SIGNALLED)).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 3);
                    continue;
                }
                if (this.suppressDeprecation & rexx.pos(Rexx.toRexx((String)MSG_DEPRECATION)).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 3);
                    continue;
                }
                if (rexx.pos(Rexx.toRexx((String)"Error:")).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 0);
                    continue;
                }
                if (rexx.pos(Rexx.toRexx((String)"Warning:")).OpGt(null, $01)) {
                    this.log(Rexx.toString((Rexx)rexx), 1);
                    continue;
                }
                this.log(Rexx.toString((Rexx)rexx), 2);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            throw new BuildException("Unexpected Exception while playing with Strings", (Throwable)exception);
        }
        finally {
            properties.put("java.class.path", string3);
        }
        if (n2 > 1) {
            throw new BuildException("Compile failed, messages should have been provided.");
        }
    }

    private String getCompileClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.destDir.getAbsolutePath());
        if (this.classpath != null) {
            this.addExistingToClasspath(stringBuffer, this.classpath);
        }
        if (this.compileClasspath != null) {
            this.addExistingToClasspath(stringBuffer, this.compileClasspath.toString());
        }
        return stringBuffer.toString();
    }

    public ArrayList getCompileOptionsAsArrayList() {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        Rexx rexx = this.getopt(Rexx.toRexx((String)"binary"), this.binary).OpCcblank(null, this.getopt(Rexx.toRexx((String)"comments"), this.comments)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"annotations"), this.comments)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"compile"), this.compile)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"compact"), this.compact)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"console"), this.console)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"crossref"), this.crossref)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"decimal"), this.decimal)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"diag"), this.diag)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"explicit"), this.explicit)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"exec"), this.exec)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"format"), this.format)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"java"), this.java_)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"keep"), this.keep)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"keepasjava"), this.keepasjava)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"logo"), this.logo)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"replace"), this.replace)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"savelog"), this.savelog)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"sourcedir"), this.sourcedir)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictargs"), this.strictargs)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictassign"), this.strictassign)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictcase"), this.strictcase)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictimport"), this.strictimport)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictprops"), this.strictprops)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"strictsignal"), this.strictsignal)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"symbols"), this.symbols)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"time"), this.time)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"utf8"), this.utf8)).OpCcblank(null, this.getopt(Rexx.toRexx((String)"warnexit0"), this.warnexit0));
        int n2 = rexx.words().toint();
        for (n = 1; n <= n2; ++n) {
            arrayList.add(rexx.word(new Rexx(n)).toString());
        }
        arrayList.add(("-" + this.trace_).toString());
        arrayList.add("-" + this.verbose);
        if (this.arg != null) {
            arrayList.add("-arg");
            arrayList.add(this.arg);
        }
        return arrayList;
    }

    public Rexx getopt(Rexx rexx, String string) {
        if (string == null) {
            return Rexx.toRexx((String)"");
        }
        Rexx rexx2 = $02.OpCc(null, rexx).OpCcblank(null, $03).OpCc(null, rexx);
        return rexx2.word(new Rexx((Project.toBoolean((String)string) ? 1 : 0) + 1));
    }

    private void addExistingToClasspath(StringBuffer stringBuffer, String string) {
        File file = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"), false);
        while (stringTokenizer.hasMoreTokens()) {
            file = this.getProject().resolveFile(stringTokenizer.nextToken());
            if (file.exists()) {
                stringBuffer.append(File.pathSeparator);
                stringBuffer.append(file.getAbsolutePath());
                continue;
            }
            this.log("Dropping from classpath: " + file.getAbsolutePath(), 3);
        }
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String string) {
        this.arg = string;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String string) {
        this.annotations = string;
    }

    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String string) {
        this.binary = string;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getCompact() {
        return this.compact;
    }

    public void setCompact(String string) {
        this.compact = string;
    }

    public String getCompile() {
        return this.compile;
    }

    public void setCompile(String string) {
        this.compile = string;
    }

    public boolean isCompile_b() {
        return this.compile_b;
    }

    public void setCompile_b(boolean bl) {
        this.compile_b = bl;
    }

    public String getConsole() {
        return this.console;
    }

    public void setConsole(String string) {
        this.console = string;
    }

    public String getCrossref() {
        return this.crossref;
    }

    public void setCrossref(String string) {
        this.crossref = string;
    }

    public String getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String string) {
        this.decimal = string;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public String getDiag() {
        return this.diag;
    }

    public void setDiag(String string) {
        this.diag = string;
    }

    public String getExplicit() {
        return this.explicit;
    }

    public void setExplicit(String string) {
        this.explicit = string;
    }

    public String getExec() {
        return this.exec;
    }

    public void setExec(String string) {
        this.exec = string;
    }

    public boolean isExec_b() {
        return this.exec_b;
    }

    public void setExec_b(boolean bl) {
        this.exec_b = bl;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public String getJavacompiler() {
        return this.javacompiler;
    }

    public void setJavacompiler(String string) {
        this.javacompiler = string;
    }

    public String getJava_() {
        return this.java_;
    }

    public void setJava_(String string) {
        this.java_ = string;
    }

    public boolean isJava_b() {
        return this.java_b;
    }

    public void setJava_b(boolean bl) {
        this.java_b = bl;
    }

    public File getJavaDir() {
        return this.javaDir;
    }

    public void setJavaDir(File file) {
        this.javaDir = file;
    }

    public String getKeep() {
        return this.keep;
    }

    public void setKeep(String string) {
        this.keep = string;
    }

    public boolean isKeep_b() {
        return this.keep_b;
    }

    public void setKeep_b(boolean bl) {
        this.keep_b = bl;
    }

    public String getKeepasjava() {
        return this.keepasjava;
    }

    public void setKeepasjava(String string) {
        this.keepasjava = string;
    }

    public boolean isKeepasjava_b() {
        return this.keepasjava_b;
    }

    public void setKeepasjava_b(boolean bl) {
        this.keepasjava_b = bl;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String string) {
        this.logo = string;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String string) {
        this.replace = string;
    }

    public String getSavelog() {
        return this.savelog;
    }

    public void setSavelog(String string) {
        this.savelog = string;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(File file) {
        this.srcDir = file;
    }

    public String getSourcedir() {
        return this.sourcedir;
    }

    public void setSourcedir(String string) {
        this.sourcedir = string;
    }

    public boolean isSourcedir_b() {
        return this.sourcedir_b;
    }

    public void setSourcedir_b(boolean bl) {
        this.sourcedir_b = bl;
    }

    public String getStrictargs() {
        return this.strictargs;
    }

    public void setStrictargs(String string) {
        this.strictargs = string;
    }

    public String getStrictassign() {
        return this.strictassign;
    }

    public void setStrictassign(String string) {
        this.strictassign = string;
    }

    public String getStrictcase() {
        return this.strictcase;
    }

    public void setStrictcase(String string) {
        this.strictcase = string;
    }

    public String getStrictimport() {
        return this.strictimport;
    }

    public void setStrictimport(String string) {
        this.strictimport = string;
    }

    public String getStrictprops() {
        return this.strictprops;
    }

    public void setStrictprops(String string) {
        this.strictprops = string;
    }

    public String getStrictsignal() {
        return this.strictsignal;
    }

    public void setStrictsignal(String string) {
        this.strictsignal = string;
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setSymbols(String string) {
        this.symbols = string;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public String getUtf8() {
        return this.utf8;
    }

    public void setUtf8(String string) {
        this.utf8 = string;
    }

    public String getWarnexit0() {
        return this.warnexit0;
    }

    public void setWarnexit0(String string) {
        this.warnexit0 = string;
    }

    public boolean isSuppressMethodArgumentNotUsed() {
        return this.suppressMethodArgumentNotUsed;
    }

    public void setSuppressMethodArgumentNotUsed(boolean bl) {
        this.suppressMethodArgumentNotUsed = bl;
    }

    public boolean isSuppressPrivatePropertyNotUsed() {
        return this.suppressPrivatePropertyNotUsed;
    }

    public void setSuppressPrivatePropertyNotUsed(boolean bl) {
        this.suppressPrivatePropertyNotUsed = bl;
    }

    public boolean isSuppressVariableNotUsed() {
        return this.suppressVariableNotUsed;
    }

    public void setSuppressVariableNotUsed(boolean bl) {
        this.suppressVariableNotUsed = bl;
    }

    public boolean isSuppressExceptionNotSignalled() {
        return this.suppressExceptionNotSignalled;
    }

    public void setSuppressExceptionNotSignalled(boolean bl) {
        this.suppressExceptionNotSignalled = bl;
    }

    public boolean isSuppressDeprecation() {
        return this.suppressDeprecation;
    }

    public void setSuppressDeprecation(boolean bl) {
        this.suppressDeprecation = bl;
    }

    public boolean isRemoveKeepExtension() {
        return this.removeKeepExtension;
    }

    public void setRemoveKeepExtension(boolean bl) {
        this.removeKeepExtension = bl;
    }

    public boolean isRemoveSourceCopies() {
        return this.removeSourceCopies;
    }

    public void setRemoveSourceCopies(boolean bl) {
        this.removeSourceCopies = bl;
    }
}

