/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import org.netrexx.process.NrVersion;
import org.netrexx.process.RxBabel;
import org.netrexx.process.RxField;
import org.netrexx.process.RxProgram;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class NrBabel
implements RxBabel {
    private static final Rexx $01 = new Rexx('[');
    private static final Rexx $02 = new Rexx(']');
    private static final Rexx $03 = Rexx.toRexx("constant");
    private static final Rexx $04 = Rexx.toRexx("final");
    private static final Rexx $05 = Rexx.toRexx("static");
    private static final Rexx $06 = Rexx.toRexx("abstract");
    private static final Rexx $07 = Rexx.toRexx("deprecated");
    private static final String $0 = "NrBabel.nrx";
    private Rexx Name = Rexx.toRexx("NetRexx");
    private Rexx Version = new NrVersion().getVersion();
    private Rexx FullVersion = new NrVersion().getFullVersion();
    private Rexx Extension = Rexx.toRexx("nrx");
    private RxTranslator rxt;
    private RxProgram program;

    public NrBabel(RxTranslator rxTranslator) {
        this.rxt = rxTranslator;
        this.program = this.rxt.program;
    }

    @Override
    public Rexx typeString(RxType rxType) {
        if (rxType.dimension == 0) {
            return rxType.classname;
        }
        return rxType.classname.OpCc(null, $01).OpCc(null, new Rexx(',').copies(new Rexx(rxType.dimension - 1))).OpCc(null, $02);
    }

    @Override
    public Rexx typeConcise(RxType rxType) {
        Rexx rexx = rxType.getPackageName();
        if (rexx == null) {
            return this.typeString(rxType);
        }
        Rexx rexx2 = rxType.getClassFileName().changestr(new Rexx('$'), new Rexx('.'));
        if (this.rxt.classer.isambiguous(this.program, rexx2)) {
            return this.typeString(rxType);
        }
        if (rxType.dimension == 0) {
            return rexx2;
        }
        return rexx2.OpCc(null, $01).OpCc(null, new Rexx(',').copies(new Rexx(rxType.dimension - 1))).OpCc(null, $02);
    }

    @Override
    public Rexx fieldVisibility(int n) {
        String string = null;
        if (n == 1) {
            string = "public";
        } else if (n == 2) {
            string = "inheritable";
        } else if (n == 3) {
            string = "shared";
        } else if (n == 4) {
            string = "private";
        } else {
            throw new NoOtherwiseException();
        }
        return Rexx.toRexx(string);
    }

    @Override
    public Rexx fieldModifiers(RxField rxField) {
        Rexx rexx = this.fieldVisibility(rxField.fieldvisib);
        if (rxField.isConstant()) {
            rexx = rexx.OpCcblank(null, $03);
        } else if (rxField.isFinal()) {
            rexx = rexx.OpCcblank(null, $04);
        } else if (rxField.isStatic()) {
            rexx = rexx.OpCcblank(null, $05);
        } else if (rxField.isAbstract()) {
            rexx = rexx.OpCcblank(null, $06);
        }
        if (rxField.isDeprecated()) {
            rexx = rexx.OpCcblank(null, $07);
        }
        return rexx.space();
    }

    @Override
    public Rexx getName() {
        return this.Name;
    }

    @Override
    public Rexx getVersion() {
        return this.Version;
    }

    @Override
    public Rexx getFullVersion() {
        return this.FullVersion;
    }

    @Override
    public Rexx getExtension() {
        return this.Extension;
    }
}

