/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.Rexx;
import org.netrexx.process.RxCode;
import org.netrexx.process.RxConvert;
import org.netrexx.process.RxCursor;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxTranslator;
import org.netrexx.process.RxType;

public class RxExpr {
    private static final String $0 = "RxExpr.nrx";
    static final int ASSIGN_EXPR = 10;
    static final int CASE_EXPR = 7;
    static final int IF_EXPR = 8;
    static final int LOOP_EXPRI = 1;
    static final int LOOP_EXPRT = 2;
    static final int LOOP_EXPRB = 3;
    static final int LOOP_EXPRF = 4;
    static final int LOOP_EXPRW = 5;
    static final int LOOP_EXPRU = 6;
    static final int NUMERIC_EXPR = 11;
    static final int RETURN_EXPR = 12;
    static final int SAY_EXPR = 13;
    static final int WHEN_EXPR = 9;
    int exprtype;
    RxCode code;
    boolean litexpr = false;
    boolean addzero = false;
    boolean addone = false;
    RxConvert conv;
    RxType type;
    private RxTranslator rxt;
    private char[] endins;
    private Rexx ender;
    private RxToken[] tokens;

    public RxExpr(RxTranslator rxTranslator, RxCursor rxCursor, int n, RxCode rxCode) {
        this.rxt = rxTranslator;
        this.exprtype = n;
        this.code = rxCode;
        this.type = this.code.type;
        this.tokens = rxCursor.curclause.tokens;
        RxToken rxToken = this.tokens[this.code.endoff + 1];
        if (rxToken.type == 'B') {
            rxToken = this.tokens[this.code.endoff + 2];
        }
        if (rxToken.type != ';') {
            if (rxToken.type == 'S') {
                this.ender = Rexx.toRexx(rxToken.value);
            } else {
                this.endins = new char[1];
                this.endins[0] = rxToken.type;
            }
        }
    }

    public RxToken firsttoken() {
        return this.tokens[this.code.begoff];
    }

    public RxCode evaluate(RxCursor rxCursor) {
        return this.evaluate(rxCursor, '>', Rexx.toRexx(""));
    }

    public RxCode evaluate(RxCursor rxCursor, char c) {
        return this.evaluate(rxCursor, c, Rexx.toRexx(""));
    }

    public RxCode evaluate(RxCursor rxCursor, char c, Rexx rexx) {
        RxCode rxCode = null;
        if (this.code.constant && rxCursor.curtrace == null) {
            return this.code;
        }
        RxCode rxCode2 = this.rxt.eparser.evalexpr(rxCursor, false, this.code.begoff, this.endins, this.ender, c, rexx);
        if (this.addzero) {
            rxCode = this.rxt.eparser.oneopdo(rxCursor, Rexx.tochararray('+'), this.tokens[this.code.begoff], rxCode2);
            rxCode2.type = rxCode.type;
            rxCode2.value = rxCode.value;
            rxCode2.constant = rxCode.constant;
        }
        if (this.litexpr) {
            this.rxt.converter.litexpr(rxCursor, rxCode2);
        }
        if (this.conv != null) {
            this.rxt.converter.convertcode(rxCursor, this.type, this.conv.proc, rxCode2, this.tokens[rxCode2.begoff]);
        }
        return rxCode2;
    }
}

