/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts.skin;

import eu.hansolo.enzo.charts.SimpleLineChart;
import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.fonts.Fonts;
import java.util.stream.IntStream;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.TextAlignment;

public class SimpleLineChartSkin
extends SkinBase<SimpleLineChart>
implements Skin<SimpleLineChart> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 100.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private boolean keepAspect = true;
    private double aspectRatio = 0.5;
    private double size;
    private double width;
    private double height;
    private double widthFactor;
    private double heightFactor;
    private double sectionMinimum;
    private double sectionMaximum;
    private Pane pane;
    private Canvas canvasBkg;
    private GraphicsContext ctxBkg;
    private Canvas canvasFg;
    private GraphicsContext ctxFg;

    public SimpleLineChartSkin(SimpleLineChart chart) {
        super((Control)chart);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SimpleLineChart)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SimpleLineChart)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SimpleLineChart)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SimpleLineChart)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SimpleLineChart)this.getSkinnable()).getPrefWidth() > 0.0 && ((SimpleLineChart)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SimpleLineChart)this.getSkinnable()).setPrefSize(((SimpleLineChart)this.getSkinnable()).getPrefWidth(), ((SimpleLineChart)this.getSkinnable()).getPrefHeight());
            } else {
                ((SimpleLineChart)this.getSkinnable()).setPrefSize(200.0, 100.0);
            }
        }
        if (Double.compare(((SimpleLineChart)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SimpleLineChart)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SimpleLineChart)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((SimpleLineChart)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SimpleLineChart)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SimpleLineChart)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.canvasBkg = new Canvas(200.0, 100.0);
        this.ctxBkg = this.canvasBkg.getGraphicsContext2D();
        this.canvasFg = new Canvas(200.0, 100.0);
        this.ctxFg = this.canvasFg.getGraphicsContext2D();
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.canvasBkg, this.canvasFg});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.resize();
        this.drawBackground();
        this.drawForeground();
    }

    private void registerListeners() {
        ((SimpleLineChart)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleLineChart)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleLineChart)this.getSkinnable()).sectionRangeVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW_BACKGROUND"));
        ((SimpleLineChart)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW_BACKGROUND"));
        ((SimpleLineChart)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleLineChart)this.getSkinnable()).getSeries().getData().addListener(change -> this.handleControlPropertyChanged("REDRAW_FOREGROUND"));
        ((SimpleLineChart)this.getSkinnable()).fromProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW_FOREGROUND"));
        ((SimpleLineChart)this.getSkinnable()).toProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW_FOREGROUND"));
        ((SimpleLineChart)this.getSkinnable()).titleVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW_FOREGROUND"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
            this.drawBackground();
            this.drawForeground();
        } else if ("REDRAW".equals(PROPERTY)) {
            this.drawBackground();
            this.drawForeground();
        } else if ("REDRAW_FOREGROUND".equals(PROPERTY)) {
            this.drawForeground();
        } else if ("REDRAW_BACKGROUND".equals(PROPERTY)) {
            this.drawBackground();
        }
    }

    private void drawForeground() {
        this.ctxFg.clearRect(0.0, 0.0, this.width, this.height);
        this.ctxFg.setStroke(((SimpleLineChart)this.getSkinnable()).getSeriesStroke());
        this.ctxFg.setLineCap(StrokeLineCap.ROUND);
        this.ctxFg.setLineJoin(StrokeLineJoin.ROUND);
        this.ctxFg.setLineWidth(0.025 * this.height);
        this.ctxFg.save();
        this.ctxFg.translate(0.0, this.sectionMinimum * this.heightFactor);
        this.widthFactor = this.width / (double)((SimpleLineChart)this.getSkinnable()).getSeries().getData().size();
        int noOfDataPoints = ((SimpleLineChart)this.getSkinnable()).getSeries().getData().size();
        if (noOfDataPoints > 2) {
            for (int i = 0; i < noOfDataPoints - 1; ++i) {
                XYChart.Data p1 = (XYChart.Data)((SimpleLineChart)this.getSkinnable()).getSeries().getData().get(i);
                XYChart.Data p2 = (XYChart.Data)((SimpleLineChart)this.getSkinnable()).getSeries().getData().get(i + 1);
                this.ctxFg.strokeLine(this.widthFactor / 2.0 + (double)i * this.widthFactor, this.height - (Double)p1.getYValue() * this.heightFactor, this.widthFactor / 2.0 + (double)(i + 1) * this.widthFactor, this.height - (Double)p2.getYValue() * this.heightFactor);
                this.drawBullet(this.ctxFg, this.widthFactor / 2.0 + (double)i * this.widthFactor, this.height - (Double)p1.getYValue() * this.heightFactor, ((SimpleLineChart)this.getSkinnable()).getBulletFill());
            }
            this.drawBullet(this.ctxFg, this.widthFactor / 2.0 + (double)(noOfDataPoints - 1) * this.widthFactor, this.height - (Double)((XYChart.Data)((SimpleLineChart)this.getSkinnable()).getSeries().getData().get(noOfDataPoints - 1)).getYValue() * this.heightFactor, ((SimpleLineChart)this.getSkinnable()).getBulletFill());
        }
        this.ctxFg.save();
        this.ctxFg.applyEffect((Effect)new DropShadow(0.025 * this.height, 0.0, 0.025 * this.height, Color.rgb((int)0, (int)0, (int)0, (double)0.65)));
        this.ctxFg.restore();
        this.ctxFg.setFill((Paint)Color.WHITE);
        this.ctxFg.setFont(Fonts.robotoLight(0.1 * this.height));
        this.ctxFg.setTextBaseline(VPos.BOTTOM);
        this.ctxFg.setTextAlign(TextAlignment.LEFT);
        this.ctxFg.fillText(((SimpleLineChart)this.getSkinnable()).getFrom(), 2.0, this.height - 2.0);
        this.ctxFg.setTextAlign(TextAlignment.RIGHT);
        this.ctxFg.fillText(((SimpleLineChart)this.getSkinnable()).getTo(), this.width - 2.0, this.height - 2.0);
        if (((SimpleLineChart)this.getSkinnable()).isTitleVisible()) {
            this.ctxFg.setTextBaseline(VPos.TOP);
            this.ctxFg.setTextAlign(TextAlignment.CENTER);
            this.ctxFg.fillText(((SimpleLineChart)this.getSkinnable()).getSeries().getName(), this.width * 0.5, 2.0);
        }
        this.ctxFg.restore();
    }

    private void drawBackground() {
        this.ctxBkg.clearRect(0.0, 0.0, this.width, this.height);
        this.sectionMinimum = Double.MAX_VALUE;
        this.sectionMaximum = -1.7976931348623157E308;
        double lowestSection = Double.MAX_VALUE;
        for (Section section : ((SimpleLineChart)this.getSkinnable()).getSections()) {
            this.sectionMinimum = Math.min(this.sectionMinimum, section.getStart());
            this.sectionMaximum = Math.max(this.sectionMaximum, section.getStop());
            lowestSection = Math.min(lowestSection, Math.abs(section.getStop() - section.getStart()));
        }
        this.ctxBkg.setStroke((Paint)Color.BLACK);
        this.ctxBkg.strokeRect(0.0, 0.0, this.width, this.height);
        this.heightFactor = this.height / (this.sectionMaximum - this.sectionMinimum);
        this.ctxBkg.save();
        this.ctxBkg.translate(0.0, this.sectionMinimum * this.heightFactor);
        this.ctxBkg.setFont(Fonts.robotoRegular(lowestSection * 0.8 * this.heightFactor));
        IntStream.range(0, ((SimpleLineChart)this.getSkinnable()).getSections().size()).forEach(i -> {
            Section SECTION = (Section)((SimpleLineChart)this.getSkinnable()).getSections().get(i);
            this.ctxBkg.save();
            switch (i) {
                case 0: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill0());
                    break;
                }
                case 1: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill1());
                    break;
                }
                case 2: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill2());
                    break;
                }
                case 3: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill3());
                    break;
                }
                case 4: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill4());
                    break;
                }
                case 5: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill5());
                    break;
                }
                case 6: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill6());
                    break;
                }
                case 7: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill7());
                    break;
                }
                case 8: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill8());
                    break;
                }
                case 9: {
                    this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSectionFill9());
                }
            }
            this.ctxBkg.fillRect(0.0, this.height - SECTION.getStop() * this.heightFactor, this.width, Math.abs(SECTION.getStop() - SECTION.getStart()) * this.heightFactor);
            this.ctxBkg.restore();
        });
        if (((SimpleLineChart)this.getSkinnable()).isSectionRangeVisible()) {
            IntStream.range(0, ((SimpleLineChart)this.getSkinnable()).getSections().size()).forEach(i -> {
                Section SECTION = (Section)((SimpleLineChart)this.getSkinnable()).getSections().get(i);
                this.ctxBkg.setFill(((SimpleLineChart)this.getSkinnable()).getSeriesStroke());
                this.ctxBkg.setTextBaseline(VPos.CENTER);
                this.ctxBkg.fillText(SECTION.getStop() + ((SimpleLineChart)this.getSkinnable()).getUnit(), 0.02 * this.height, this.height - SECTION.getStop() * this.heightFactor);
            });
        }
        this.ctxBkg.restore();
    }

    private void drawBullet(GraphicsContext CTX, double X, double Y, Paint COLOR) {
        double iconSize = 0.04 * this.size;
        CTX.save();
        CTX.setLineWidth(0.0125 * this.height);
        CTX.setStroke(((SimpleLineChart)this.getSkinnable()).getSeriesStroke());
        CTX.setFill(COLOR);
        CTX.strokeOval(X - iconSize * 0.5, Y - iconSize * 0.5, iconSize, iconSize);
        CTX.fillOval(X - iconSize * 0.5, Y - iconSize * 0.5, iconSize, iconSize);
        CTX.restore();
    }

    private void resize() {
        this.size = ((SimpleLineChart)this.getSkinnable()).getWidth() < ((SimpleLineChart)this.getSkinnable()).getHeight() ? ((SimpleLineChart)this.getSkinnable()).getWidth() : ((SimpleLineChart)this.getSkinnable()).getHeight();
        this.width = ((SimpleLineChart)this.getSkinnable()).getWidth();
        this.height = ((SimpleLineChart)this.getSkinnable()).getHeight();
        if (this.keepAspect) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.canvasBkg.setWidth(this.width);
            this.canvasBkg.setHeight(this.height);
            this.canvasFg.setWidth(this.width);
            this.canvasFg.setHeight(this.height);
            this.drawBackground();
            this.drawForeground();
        }
    }
}

